<?php
/**
* LICENCIA
*
* Este programa se propociona "tal cual", sin garantía de ningún tipo más allá del soporte
* pactado a la hora de adquirir el programa.
*
* En ningún caso los autores o titulares del copyright serán responsables de ninguna
* reclamación, daños u otras responsabilidades, ya sea en un litigio, agravio o de otro
* modo, que surja de o en conexión con el programa o el uso u otro tipo de acciones
* realizadas con el programa.
*
* Este programa no puede modificarse ni distribuirse sin el consentimiento expreso del autor.
*
*    @author    Carlos Fillol Sendra <festeweb@festeweb.com>
*    @copyright 2014 Fes-te web! - www.festeweb.com
*    @license   http://www.festeweb.com/static/licenses/fs2ps_1.1.0.txt
*/

include_once(dirname(__FILE__).'/../../Fs2psException.php');
include_once(dirname(__FILE__).'/../../Fs2psTools.php');
include_once(dirname(__FILE__).'/../../Fs2psTaskManager.php');


class Fs2psDefaultModuleFrontController 
{
	protected $task_mng;

	public function __construct()
	{
		$this->task_mng = new Fs2psTaskManager();
	}

	private function error($msg, $exception=null)
	{
	    $json = array(
	        'status' => 'error',
	        'msgs' => array($msg)
	    );
	    if ($exception) {
	        $json['exception'] = get_class($exception);
	        $json['traceback'] = ((string)$exception);
	    }
	    return Fs2psTools::jsonEncode($json);
	}
	
	private function logException($e)
	{
		$error_msg = 'fs2py: '.((string)$e);
		$error_msg = preg_replace('/[<>{}]/i', '', $error_msg);
		echo $error_msg;
	}

	public function initContent()
	{
		$error = null;
		$response = null;
		try
		{
			header('Content-type: application/json; charset=utf-8');
			if (empty($_POST['cmd']) && empty($_POST['c'])){
				$cmd_txt = file_get_contents('php://input');
				if(empty($cmd_txt)) {
					throw new Fs2psException('Llamada inválida. No se indicó "cmd"');
				}
			}else{
			    # Bug de wordpress: http://core.trac.wordpress.org/ticket/18322
			    $post = array_map('stripslashes_deep', $_POST);
			    $cmd_txt = empty($post['cmd'])? $post['c'] : $post['cmd'];
			}

			if (substr($cmd_txt, 0, 1)!=="{")
			    $cmd_txt = base64_decode($cmd_txt);
			    
		    // get_magic_quotes_gpc() ?
		    if (substr($cmd_txt, 0, 2)==="{\\")
		        $cmd_txt = stripslashes($cmd_txt);
			
            $cmd = Fs2psTools::jsonDecode($cmd_txt); 
			if (empty($cmd))
				throw new Fs2psException('Formato JSON incorrecto');

			$response = Fs2psTools::jsonEncode($this->task_mng->attendCmd($cmd));
			
		}
		catch (Fs2psException $e)
		{
		    $error = $this->error($e->getMessage(), $e);
		}
		catch (Exception $e)
		{
		    $this->logException($e);
		    $error = $this->error('Excepción inesperada. Consulte el log para ver detalles.', $e);
		}
		
		// Finally
		if ($error)
			die($error);

		if ($response)
			die($response);

	}

}
