<?php
/**
 * LICENCIA
 *
 * Este programa se propociona "tal cual", sin garantía de ningún tipo más allá del soporte
 * pactado a la hora de adquirir el programa.
 *
 * En ningún caso los autores o titulares del copyright serán responsables de ninguna
 * reclamación, daños u otras responsabilidades, ya sea en un litigio, agravio o de otro
 * modo, que surja de o en conexión con el programa o el uso u otro tipo de acciones
 * realizadas con el programa.
 *
 * Este programa no puede modificarse ni distribuirse sin el consentimiento expreso del autor.
 *
 *    @author    Carlos Fillol Sendra <festeweb@festeweb.com>
 *    @copyright 2014 Fes-te web! - www.festeweb.com
 *    @license   http://www.festeweb.com/static/licenses/fs2ps_1.1.0.txt
 */

include_once(dirname(__FILE__).'/Fs2psTask.php');
include_once(dirname(__FILE__).'/Fs2psExtractors.php');
include_once(dirname(__FILE__).'/Fs2psTools.php');

class Fs2psWcpdfInvoiceDownloadInvoicesTask extends Fs2psExtractorTask
{
    public function __construct($mng, $cmd)
    {
        parent::__construct('download_invoices', $mng, $cmd);
        $this->addExtractor('invoices', 'Fs2psWcpdfInvoiceOrderExtractor');
        $this->addExtractor('invoice_lines', 'Fs2psOrderLineExtractor');
    }
}

class Fs2psWcpdfInvoiceOrderExtractor extends Fs2psOrderExtractor {

    protected $wcpdf_invoice_use_metas;
    
    protected function reloadCfg() {
        parent::reloadCfg();
        $cfg = $this->task->cfg;
        $this->wcpdf_invoice_use_metas = $cfg->get('WCPDF_INVOICE_USE_METAS');
    }

    protected function row2dto($row) {

        $dto = parent::row2dto($row);
        if (empty($dto)) return $dto;
        
        $post_id = intval($dto['id']);
        if ($this->wcpdf_invoice_use_metas) {
            $dto['invoice'] = Fs2psTools::dbValue('
                SELECT meta_value as invoice
                FROM @DB_postmeta
                where meta_key=\'_wcpdf_invoice_number\' and post_id='.$post_id
            );
            $dto['invoice_date'] = Fs2psTools::dbValue('
                SELECT meta_value as invoice_date
                FROM @DB_postmeta
                where meta_key=\'_wcpdf_invoice_date_formatted\' and post_id='.$post_id
            );
        } else {
            $dto['invoice'] = intval(Fs2psTools::dbValue('
                SELECT id as invoice
                FROM @DB_wcpdf_invoice_number
                where order_id='.$post_id)
            );
            $dto['invoice_date'] = Fs2psTools::dbValue('
                SELECT date as invoice_date
                FROM @DB_wcpdf_invoice_number
                where order_id='.$post_id
            );
        }
        
        return $dto;
    }
}
