<?php
/**
* LICENCIA
*
* Este programa se propociona "tal cual", sin garantía de ningún tipo más allá del soporte
* pactado a la hora de adquirir el programa.
*
* En ningún caso los autores o titulares del copyright serán responsables de ninguna
* reclamación, daños u otras responsabilidades, ya sea en un litigio, agravio o de otro
* modo, que surja de o en conexión con el programa o el uso u otro tipo de acciones
* realizadas con el programa.
*
* Este programa no puede modificarse ni distribuirse sin el consentimiento expreso del autor.
*
*    @author    Carlos Fillol Sendra <festeweb@festeweb.com>
*    @copyright 2014 Fes-te web! - www.festeweb.com
*    @license   http://www.festeweb.com/static/licenses/fs2ps_1.1.0.txt
*/

include_once(dirname(__FILE__).'/Fs2psTools.php');
include_once(dirname(__FILE__).'/Fs2psTask.php');
include_once(dirname(__FILE__).'/Fs2psUpdaters.php');

require_once(ABSPATH . 'wp-admin/includes/image.php');

class Fs2psUploadProductImagesTask extends Fs2psUpdaterTask
{

	public function __construct($mng, $cmd)
	{
		parent::__construct('upload_product_images', $mng, $cmd);
		$this->addUpdater('products', 'Fs2psProductUpdater');
		$this->addUpdater('colours', 'Fs2psAttributeUpdater');
		$this->addUpdater('sizes', 'Fs2psAttributeUpdater');
	}

	protected function error($msg)
	{
		if ($this->stop_on_error)
			throw new Fs2psException($msg);
		$this->log('ERROR: '.$msg);
	}
	
	protected function getEmptyAttachment($position) {
		return array(
			'post_mime_type' => 'image/jpeg',
			'post_title' => 'empty-'.$position.'.jpg',
			'post_content' => '',
			'post_status' => 'inherit'
		);
	}

	protected function _execute($cmd)
	{
		// { op:'...', images: [ product: 'Z001', file_name: '...., data: ' ' ]}

		$products_udt = $this->getUpdater('products');
		$colours_upd = $this->getUpdater('colours');
		$sizes_upd = $this->getUpdater('sizes');
		
		$product_images = array();
		if (isset($cmd['product_images'])) $product_images = $cmd['product_images'];
		
		
		$last_id_product = 0;
		$images = null;
		
		//$colour_tax_name = $products_udt->matcher->attributeNameFromDtoId('COLOURS');
		
		$upload_products_images = $this->cfg->get('UPLOAD_PRODUCTS_IMAGES', '');
		$coveringallery = strpos($upload_products_images, 'coveringallery')!==false;
		
		foreach ($product_images as $dto)
		{
			$position = empty($dto['position'])? 1 : intval($dto['position']);
			$id_product = $products_udt->matcher->rowIdFromDtoId($dto['product']);
			if (!$id_product) {
				$this->error('El producto no existe: '.$dto['product']);
				continue;
			}
			
			$id_colour = null;
			if ((isset($dto['colour']) && (!empty($dto['colour']) || $dto['colour']==='0')))
			{
			    $id_colour = $colours_upd->matcher->rowIdFromDtoId($dto['colour']);
			    if (!$id_colour) {
			        $this->error('El color no existe: '.$dto['colour']);
			        continue;
			    }
			}
			
			$id_size = null;
			if ((isset($dto['size']) && (!empty($dto['size']) || $dto['size']==='0')))
			{
			    $id_size = $sizes_upd->matcher->rowIdFromDtoId($dto['size']);
			    if (!$id_size) {
			        $this->error('La talla no existe: '.$dto['size']);
			        continue;
			    }
			}

			if ($last_id_product!=$id_product) {
                $images = get_attached_media('image', $id_product);
				$orderedImages = [];
				foreach ($images as $k=>$v) {
					preg_match('/[_-](?<position>[0-9]+)\.[A-Za-z0-9]+$/', $v->post_title, $matches);
					$lastNum = intval($matches? $matches['position']: 1);
					$orderedImages[$lastNum] = $v->ID;
				}
				ksort($orderedImages);
                $images_ids = array_values($orderedImages);
                $new_images_ids = array_values($orderedImages);
			}
			
			if ($position>=1) {
    							
				// Borramos anterior en esta posición si la hay
    			if ($position<=sizeof($images_ids)) {
					wp_delete_attachment($images_ids[$position-1], true);
					$images_ids[$position-1] = null;
				}
				if (!empty($dto['last'])) {
					// Si se indica el último índice, eliminamos imágenes posteriores a la última si las hubiera
					// (si last y position==0 se eliminarían todas)
					for ($d = $position; $d<sizeof($images_ids); $d++) {
						wp_delete_attachment($images_ids[$d], true);
						$images_ids[$d] = null;
					}
				}
    		    
				// Creamos la imagen
    			$upload = wp_upload_bits($dto['name'], null, Fs2psTools::base64DataDecode($dto['data']));
    			$file_path = $upload['file'];
    			$wp_filetype = wp_check_filetype($upload['file'], null);
    			$attachment = array(
    			    'post_mime_type' => $wp_filetype['type'],
    			    'post_title' => sanitize_file_name($dto['name']),
    			    'post_content' => '',
    			    'post_status' => 'inherit',
					'post_author' => $cmd['cfg']['POST_AUTHOR'] ?? 0
    			);
				
				if (isset($dto['descrip'])) $attachment['post_content'] = $dto['descrip'];
				if (isset($dto['caption'])) $attachment['post_excerpt'] = $dto['caption']; // Leyenda

				// Rellenamos huecos hasta $position para conservar el orden
				for ($p = 1; $p <$position; $p++) {
					if (!empty($images_ids[$p-1]) || !empty($new_images_ids[$p-1])) continue;
					$attach_id = wp_insert_attachment($this->getEmptyAttachment($p), FALSE, $id_product); # Create empty attachment
					$new_images_ids[$p-1] = $attach_id;
				}
    			$attach_id = wp_insert_attachment($attachment, $file_path, $id_product);
    			$attach_data = wp_generate_attachment_metadata($attach_id, $file_path);
				update_post_meta($attach_id, '_fw_position', $position);
    			wp_update_attachment_metadata($attach_id, $attach_data);

				// Establecemos como imagen de portada si position=1
				if ($position==1) set_post_thumbnail($id_product, $attach_id);
				$new_images_ids[$position-1] = $attach_id;
    			
				if (isset($dto['alt'])) update_post_meta($attach_id, '_wp_attachment_image_alt', $dto['alt']);
   		  
    			// Vinculamos imagen con combinaciones correspondientes
    			if ($id_colour || $id_size)
    			{
    			    $rows = Fs2psTools::dbSelect('
						select p.ID
						from 
						@DB_posts p
						'.($id_colour ? '
						inner join @DB_terms color on color.term_id='.$id_colour.'
						inner join @DB_postmeta pmc on pmc.post_id=p.ID and pmc.meta_key=\'attribute_pa_color\' and pmc.meta_value=color.slug
						' : '').'
						'.($id_size ? '
						inner join @DB_terms talla on talla.term_id='.$id_size.'
						inner join @DB_postmeta pmt on pmt.post_id=p.ID and pmt.meta_key=\'attribute_pa_size\' and pmt.meta_value=talla.slug
						' : '').'
						where p.post_parent='.$id_product.' and p.post_type=\'product_variation\'
    				');
    			    foreach ($rows as $row) set_post_thumbnail($row['ID'], $attach_id);    
    			}

			}
			
			$gallery_images = $coveringallery? $new_images_ids : array_slice($new_images_ids, 1);
			update_post_meta($id_product, '_product_image_gallery', implode(',', $gallery_images));
			
			$last_id_product = $id_product;
			
		}
		
	}
	
}
