<?php
/**
* LICENCIA
*
* Este programa se propociona "tal cual", sin garantía de ningún tipo más allá del soporte
* pactado a la hora de adquirir el programa.
*
* En ningún caso los autores o titulares del copyright serán responsables de ninguna
* reclamación, daños u otras responsabilidades, ya sea en un litigio, agravio o de otro
* modo, que surja de o en conexión con el programa o el uso u otro tipo de acciones
* realizadas con el programa.
*
* Este programa no puede modificarse ni distribuirse sin el consentimiento expreso del autor.
*
*    @author    Carlos Fillol Sendra <festeweb@festeweb.com>
*    @copyright 2014 Fes-te web! - www.festeweb.com
*    @license   http://www.festeweb.com/static/licenses/fs2ps_1.1.0.txt
*/

include_once(dirname(__FILE__).'/Fs2psTask.php');

class Fs2psTruncateCatalogTask extends Fs2psTask
{

	public function __construct($mng, $cmd)
	{
		parent::__construct('truncate_catalog', $mng, $cmd);
	}

	protected function _execute($cmd)
	{
		// Task only available for test mode
		if (!defined('_FS2PS_TEST_MODE_') || !_FS2PS_TEST_MODE_)
			throw new Fs2psException(
				'"truncate_catalog" disponible sólo en modo de pruebas');
		
		if (empty($cmd['notcatalog']))
		{
			// Remove product_cat, attributes groups, attribute values and product variations
			Fs2psTools::dbExec("
				DELETE pm, p, tr, t, tt
				FROM @DB_term_taxonomy tt
				LEFT JOIN @DB_terms t ON t.term_id=tt.term_id
				LEFT JOIN @DB_term_relationships tr ON tr.term_taxonomy_id=tt.term_taxonomy_id
				LEFT JOIN @DB_posts p ON p.ID=tr.object_id
				LEFT JOIN @DB_postmeta pm ON pm.post_id=p.ID
				WHERE tt.taxonomy IN (
				    'product_cat', 'pa_size', 'pa_color'
				)
			");
			
			// Clear products and links to this products
			Fs2psTools::dbExec("
				DELETE tr, pm, p
				FROM @DB_posts p
				LEFT JOIN @DB_postmeta pm ON pm.post_id=p.ID
				LEFT JOIN @DB_term_relationships tr ON tr.object_id=p.ID
				WHERE p.post_type in ('product', 'product_variation')
			");
			
			Fs2psTools::dbExec("
				DELETE wo_tt
				FROM @DB_woocommerce_attribute_taxonomies wo_tt
				WHERE wo_tt.attribute_name IN ('size', 'color')
			");
			
			delete_transient( 'wc_attribute_taxonomies' );
			
			if (count(Fs2psTools::dbSelect("
				SHOW TABLES LIKE '@DB_woocommerce_termmeta'
			"))==1) {
				Fs2psTools::dbExec("
					DELETE FROM @DB_woocommerce_termmeta
					WHERE meta_key='product_count_product_cat'
				");
			} else {
				Fs2psTools::dbExec("
					DELETE FROM @DB_termmeta
					WHERE meta_key='product_count_product_cat'
				");
			}
		}
		
		if (empty($cmd['notmathes']))
		{
			// Truncate fs2ps tables

			if (empty($cmd['notgroupmathes']))
				Fs2psTools::dbExec('TRUNCATE TABLE `@DB_fs2ps_match`');
			else
			{
				Fs2psTools::dbExec('
					DELETE FROM `@DB_fs2ps_match`
					WHERE `table`<>\'group\'
				');
			}
			
			$tables = array('fs2ps_task_log', 'fs2ps_task');
			foreach ($tables as $table)
			{
				Fs2psTools::dbExec('
					DELETE FROM `@DB_'.$table.'` 
					WHERE id_task<>'.$this->id_task
				);
			}
		}
		
	}

}
