<?php
/**
* LICENCIA
*
* Este programa se propociona "tal cual", sin garantía de ningún tipo más allá del soporte
* pactado a la hora de adquirir el programa.
*
* En ningún caso los autores o titulares del copyright serán responsables de ninguna
* reclamación, daños u otras responsabilidades, ya sea en un litigio, agravio o de otro
* modo, que surja de o en conexión con el programa o el uso u otro tipo de acciones
* realizadas con el programa.
*
* Este programa no puede modificarse ni distribuirse sin el consentimiento expreso del autor.
*
*    @author    Carlos Fillol Sendra <festeweb@festeweb.com>
*    @copyright 2014 Fes-te web! - www.festeweb.com
*    @license   http://www.festeweb.com/static/licenses/fs2ps_1.1.0.txt
*/

include_once(dirname(__FILE__).'/Fs2psException.php');

use Automattic\WooCommerce\Internal\ProductAttributesLookup\LookupDataStore as ProductAttributesLookupDataStore;

class Fs2psTools
{

	public static function strtolower($str)
	{
		return strtolower($str);
	}
	
	public static function ucfirst($str)
	{
		return ucfirst($str);
	}
	
	public static function get($_array, $key, $_default = null)
	{
		return isset($_array[$key]) ? $_array[$key] : $_default;
	}

	public static function hashedBy($array, $prop_name)
	{
		$hashed_array = array();
		foreach ($array as $el)
			$hashed_array[$el[$prop_name]] = $el;
		return $hashed_array;
	}

	public static function jsonEncode($obj)
	{
		return json_encode($obj);
	}

	public static function jsonDecode($str)
	{
		return json_decode($str, true);
	}

	public static function base64DataDecode($base64_string)
	{
	    $data = explode(',', $base64_string);
	    return base64_decode(end($data));
	}
	
	public static function base64DataToFile($base64_string, $output_file)
	{
		$ifp = fopen($output_file, 'wb');

		$data = explode(',', $base64_string);

		fwrite($ifp, base64_decode(end($data)));
		fclose($ifp);

		return $output_file;
	}

	public static function insertOrUpdate($table, $id_col, $values)
	{
		$id = !empty($values[$id_col]) ? $values[$id_col] : null;

		$escaped = $values; // No es necesario escapar cuando se usa dbUpdate o dbInsert
		/*
		$escaped = array();
		foreach ($values as $key => $value)
			$escaped[$key] = is_string($value) ? Fs2psTools::dbEscape($value) : $value;
		*/

		if ($id)
		{
		    if (Fs2psTools::dbUpdate($table, $escaped, array($id_col=>$id))) {
				return $id;
            } else {
				throw new Fs2psException("No se pudo actualizar registro $id_col=$id en $table: \n".Fs2psTools::jsonEncode($values));
            }
		}
		else
		{
		    if (Fs2psTools::dbInsert($table, $escaped)) {
				return Fs2psTools::dbInsertId();
		    } else {
				throw new Fs2psException("No se pudo insertar en $table: \n".Fs2psTools::jsonEncode($values));
		    }
		}
	}

	public static function multiLangField($value, $all_langs)
	{
		return $value;
	}

	public static function linkRewrite($text)
	{
		return null;
	}

	public static function multiLangLinkRewrite($text, $all_langs)
	{
		return Fs2psTools::multiLangField(Fs2psTools::linkRewrite($text), $all_langs);
	}

	public static function arrayToObject($array)
	{
		foreach ($array as $key => $value)
		{
			if (is_array($value))
				$array[$key] = self::arrayToObject($value);
		}
		return (object)$array;
	}

	public static function isAssoc($arr)
	{
		return is_array($arr) && array_keys($arr)!==range(0, count($arr) - 1);
	}
	
	public static function replaceObjOrArray(&$target, $values)
	{
		if (is_object($values))
			$values = get_object_vars($values);

		if (is_object($target))
		{
			foreach ($values as $key => $value)
				$target->$key = $value;
		}
		else
		{
			foreach ($values as $key => $value)
				$target[$key] = $value;
		}
	}

	public static function tableToObjectModelCls($table)
	{
		$parts = explode('_', $table);
		$capitalized_parts = array();
		foreach ($parts as $part)
			$capitalized_parts[] = self::ucfirst(self::strtolower($part));
		return join('', $capitalized_parts);
	}

	public static function now()
	{
		return date('Y-m-d H:i:s');
	}
	
	protected static function sqlReplace($sql) 
	{
	    global $wpdb;
		$sql = str_replace('@DB_', $wpdb->prefix, $sql);
		$sql = str_replace('@ENG', 'InnoDB', $sql);
		return $sql;
	}
	
	public static function dbEscape($str)
	{
		return esc_sql($str);
	}
	
	public static function checkWpdbErr($sql=null)
	{
	    global $wpdb;
	    if ($wpdb->last_error) {
	        throw new Fs2psDbException($wpdb->last_error, $sql);
	    }
	}
	
	public static function dbExecFile($file_path)
	{
		$commands = file_get_contents($file_path);
		$statements = preg_split('/; *(\r\n|\n)+/', $commands);
		foreach ($statements as $statement)
		{
			$statement = trim($statement);
			if (!empty($statement)) 
				self::dbExec($statement);
		}
	}
	
	public static function dbExec($sql)
	{
		global $wpdb;
        $sql = self::sqlReplace($sql);
		
		$result = $wpdb->query($sql);
		
		self::checkWpdbErr($sql);
		/*
		if ($result === false) {
		    throw new Fs2psDbException('Error al ejecutar el SQL', $sql);
        }
        */
		return $result;
	}
	
	public static function dbSelect($sql)
	{
		global $wpdb;
		$sql = self::sqlReplace($sql);
		
		$result = $wpdb->get_results($sql, ARRAY_A);
		
		self::checkWpdbErr($sql);
		return $result;
	}
	
	public static function dbValue($sql)
	{
		global $wpdb;
		$sql = self::sqlReplace($sql);
		
		$result = $wpdb->get_var($sql);
		self::checkWpdbErr($sql);
		/*
		if ($result === null) {
		    throw new Fs2psDbException('Error al ejecutar el SQL', $sql);
		}
		*/
		return $result;
		
	}
	
	public static function dbRow($sql)
	{
		global $wpdb;
		$sql = self::sqlReplace($sql);
		
		$result = $wpdb->get_row($sql, ARRAY_A);
		
		self::checkWpdbErr($sql);
		return $result;
	}
	
	public static function dbInsert($table, $data)
	{
		global $wpdb;
		
		$result = $wpdb->insert($wpdb->prefix.$table, $data);
		
		self::checkWpdbErr();
		return $result;
	}
	
	public static function dbInsertId()
	{
		global $wpdb;
		return $wpdb->insert_id;
	}
	
	public static function dbUpdate($table, $data, $where)
	{
		global $wpdb;
		
		$result = $wpdb->update($wpdb->prefix.$table, $data, $where);
		
		self::checkWpdbErr();
		return $result;
	}
	
	public static function dbExists($table, $id_field, $id_value)
	{
		return self::dbValue(
			'select count(1) from @DB_'.$table.' where '.$id_field.'=\''.$id_value.'\''
		);
	}
	
	public static function wpErr($result) {
		if( is_wp_error( $result ) )
			throw new Fs2psWpException($result);
		return $result;
	}
	
	public static $DB_DATE_FORMAT = 'Y-m-d H:i:s';
	public static function date2db($date)
	{
		return $date->format(self::$DB_DATE_FORMAT);
	}
	public static function db2date($db_date)
	{
		return DateTime::createFromFormat(self::$DB_DATE_FORMAT , $db_date);
	}
	
	public static $DTO_DATE_FORMAT = 'Y-m-d H:i:s';
	public static function date2dto($date)
	{
		return $date->format(self::$DTO_DATE_FORMAT);
	}
	public static function dto2date($dto_date)
	{
		return DateTime::createFromFormat(self::$DTO_DATE_FORMAT , $dto_date);
	}
	
	public static function randomPassword() {
	    $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
	    $pass = array(); //remember to declare $pass as an array
	    $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
	    for ($i = 0; $i < 8; $i++) {
	        $n = rand(0, $alphaLength);
	        $pass[] = $alphabet[$n];
	    }
	    return implode($pass); //turn the array into a string
	}
	
	public static function mkdirs($base_folder, $subpath, $mode=0770, $add_index_file=true) {
	    if (!file_exists($base_folder)) throw new Fs2psServerFatalException("No exists base folder: ".$base_folder);
	    
	    $base_folder = rtrim($base_folder, " \t\n\r\0\x0B/");
	    $subpath = trim($subpath, " \t\n\r\0\x0B/");
	    
	    $folder = $base_folder;
	    $subdirs = explode('/', $subpath);
	    foreach ($subdirs as $subdir) {
	        $folder = $folder.'/'.$subdir;
	        if (!file_exists($folder)) {
	            mkdir($folder, $mode);
	            file_put_contents($folder.'/index.html', '');
	        }
	    }
	    
	}
	
	
	public static function ps_round($value, $places, $mode = PHP_ROUND_HALF_UP)
	{
		return round($value, $places, $mode);
	}
	
	public static function extractEmails($string){
	    $matches = array();
	    $pattern = '/[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b/i';
	    preg_match_all($pattern, $string, $matches);
	    return $matches? $matches[0] : array();
	}
	
	public static function replaceTags($template, $placeholders){
	    $placeholders = array_merge($placeholders, array('<?'=>'', '?>'=>''));
	    return str_replace(array_keys($placeholders), $placeholders, $template);
	}
	
	public static function htmlToPlainText($html) {
	    $patrones = array ('/(<br>|\n\r|\n)/', '/<[^>]+>/');
	    $sustitución = array (' ', '');
	    return preg_replace($patrones, $sustitución, $html);
	}
	
	public static function isSlug($str)
	{
	    $matches = null;
	    preg_match('/^[a-z0-9\-\_]+$/', $str, $matches);
	    return $matches? true : false;
	}

	public static function str2DbAlias($str)
	{
		$str = preg_replace('/\s+/', '_', $str);
		$str = preg_replace('/[^A-Za-z0-9_ ]/', '', $str);
		$str = preg_replace('/^_+/', '', $str);
		$str = preg_replace('/_+$/', '', $str);
		return $str;
	}
	
	public static function dbInStr($values, $prefix=null)
	{
	    $inValues = array();
	    $prefix = empty($prefix)? '' : $prefix;
	    for ($i = 0; $i<sizeof($values); $i++) $inValues[] = is_long($values[$i]) && empty($prefix)? $values[$i] : '\''.$prefix.$values[$i].'\'';
	    return join(',', $inValues);
	}
	
	
	public static function wooVer($version, $comparison = '>=') {
        global $woocommerce;
        return version_compare($woocommerce->version, $version, $comparison);
	}
	
	
	protected static $woo_public_update_lookup_table = NULL;
	protected static $woo_product_ds = NULL;
	protected static $woo_combi_ds = NULL;
		
	// mejor llamar directamente a clean_post_cache($id)?
	public static function wooClearCache($id, $is_combi) {
	    //clean_post_cache($id); // Limpia toda la cache del post excepto transients. Tampoco regenera lookup_table. 
	    
	    wc_delete_product_transients($id); // Necesario?
	    wp_cache_delete($id, 'post_meta'); // Necesario?
	    wp_cache_delete('lookup_table', 'object_' . $id);
	    
	    if ($is_combi) {
	        if (!self::$woo_combi_ds) self::$woo_combi_ds = \WC_Data_Store::load('product-variation');
	        $ds = self::$woo_combi_ds;
	    } else {
	        if (!self::$woo_product_ds) self::$woo_product_ds = \WC_Data_Store::load('product');
	        $ds = self::$woo_product_ds;
	    }
	    
	    if (self::$woo_public_update_lookup_table === NULL) {
	        if (method_exists('WC_Product_Data_Store_CPT', 'update_lookup_table')) {
	            $product_data_store	 = new \WC_Product_Data_Store_CPT();
	            $reflection = new \ReflectionMethod($product_data_store, 'update_lookup_table');
	            self::$woo_public_update_lookup_table = $reflection->ispublic();
	        } else self::$woo_public_update_lookup_table = FALSE;
	    }
        if (self::$woo_public_update_lookup_table) {
            $ds->update_lookup_table($id, 'wc_product_meta_lookup');
        } else {
            $ds->update_product_sales($id, 0, 'increase');
        }
	}

	protected static $attrib_lookup_queue = NULL;
	
	public static function wooQueueProductAttributeLookupUpdate($id) { // , $is_combi) {
		// TODO: Funciona el filtro por color o talla si no se ejecuta esta parte del código al actualizar combis?
		if (self::$attrib_lookup_queue===NULL) {
			try {
				$attrib_lookup_ds = wc_get_container()->get( ProductAttributesLookupDataStore::class );
				if ($attrib_lookup_ds && $attrib_lookup_ds->check_lookup_table_exists()) {
					self::$attrib_lookup_queue = WC()->get_instance_of( \WC_Queue::class );
				}
			} catch (Exception $e) { }
			if (!self::$attrib_lookup_queue) self::$attrib_lookup_queue = FALSE;
		}
		if (self::$attrib_lookup_queue) {
			$args = array( $id, 1 );
			$already_scheduled = self::$attrib_lookup_queue->search(
				array(
					'hook'   => 'woocommerce_run_product_attribute_lookup_update_callback',
					'args'   => $args,
					'status' => \ActionScheduler_Store::STATUS_PENDING,
				),
				'ids'
			);
			if ( empty( $already_scheduled ) ) {
				self::$attrib_lookup_queue->schedule_single(
					WC()->call_function( 'time' ) + 1,
					'woocommerce_run_product_attribute_lookup_update_callback',
					$args,
					'woocommerce-db-updates'
				);
			}
			//do_action( 'woocommerce_after_' . $this->object_type . '_object_save', $this, $this->data_store );?
		}
	}


	public static function isPluginActive($plugin) {
		return in_array($plugin, (array) get_option( 'active_plugins', array() ), true );
	}

	public static function remove_special_chars($value) {
		return preg_replace('/[^a-z0-9]/i', '', $value);;
	}

	
}
