<?php
/*
Plugin Name: Fs2ps
Plugin URI: http://www.festeweb.com/conector-factusol-woocommerce
Description: Una herramienta para sincronizar FactuSOL y WooCommerce
Version: 2.19.2
Author: Carlos Fillol Sendra
Author URI: http://www.festeweb.com/
*/

$dir = fs2ps_dir();

@include_once "$dir/controllers/front/default.php";

function fs2ps_dir() {
  if (defined('FS2PS_DIR') && file_exists(FS2PS_DIR)) {
    return FS2PS_DIR;
  } else {
    return dirname(__FILE__);
  }
}

// TODO cfillol: Controlar versiones mínimas
// WooCommerce >= 3.2.0
function fs2ps_init() {
  //global $fs2ps;
  /*
  if (phpversion() < 5) {
    add_action('admin_notices', 'json_api_php_version_warning');
    return;
  }
  */

  //add_filter('rewrite_rules_array', 'fs2ps_rewrites');
  
  add_action('template_redirect', 'template_redirect');
  add_action('admin_menu', 'fs2ps_settings');
  
  // Para evitar Wordpress borre productos en papelera automáticamente al cabo de 30 días
  // remove_action('wp_scheduled_delete', 'wp_scheduled_delete');
}

function template_redirect() {
    if (isset($_REQUEST['module']) && $_REQUEST['module']=='fs2ps') {
	  http_response_code(200); // Evitamos problemas 404 de otros plugins o temas
	  $controller = new Fs2psDefaultModuleFrontController();
	  $controller->initContent();
	  exit;
	}
}

function fs2ps_activation() {
  // Add the rewrite rule on activation
  global $wp_rewrite;
  add_rewrite_rule('^fs2ps/?','index.php?','top');
  //add_filter('rewrite_rules_array', 'fs2ps_rewrites');
  $wp_rewrite->flush_rules();
  
  Fs2psTools::dbExec('
	CREATE TABLE IF NOT EXISTS `@DB_fs2ps_task` (
	`id_task` int(10) unsigned auto_increment,
	`op` varchar(50),
	`started` datetime,
	`finished` datetime default null,
	`status_msg` varchar(100),
	`status` varchar(50),
	`progress` float unsigned,
	`extra_info` mediumtext,
	PRIMARY KEY (`id_task`))
	ENGINE=@ENG DEFAULT CHARSET=utf8
  ');
  
  Fs2psTools::dbExec('
	CREATE TABLE IF NOT EXISTS `@DB_fs2ps_task_log` (
	`id_log` int(10) unsigned auto_increment,
	`id_task` int(10) unsigned,
	`order` int(10) unsigned,
	`msg` text,
	`created` datetime,
	`read` tinyint(1) unsigned NOT NULL default \'0\',
	PRIMARY KEY (`id_log`))
	ENGINE=@ENG DEFAULT CHARSET=utf8
  ');
  
  Fs2psTools::dbExec('
	CREATE TABLE IF NOT EXISTS `@DB_fs2ps_match` (
	`table` varchar(254) NOT NULL,
	`dto_id` varchar(254) NOT NULL,
	`row_id` integer NOT NULL,
	`uploaded` tinyint NOT NULL,
  	`entity` varchar(254)
  	)
	ENGINE=@ENG DEFAULT CHARSET=utf8
  ');
  
  if (count(Fs2psTools::dbSelect('
    SHOW INDEX FROM `@DB_fs2ps_match`
	WHERE key_name=\'reverse_match\'
  '))==0)
  {
  	// Create index to optimize reverse match search, if not created yet
    Fs2psTools::dbExec('
	  ALTER TABLE `@DB_fs2ps_match`
	  ADD INDEX `reverse_match` (`table`, `entity`, row_id)
    ');
  }
  
  if (count(Fs2psTools::dbSelect('
    SHOW INDEX FROM `@DB_fs2ps_match`
	WHERE key_name=\'primary_replacement\'
  '))==0)
  {
  	// Create index to optimize reverse match search, if not created yet
  	Fs2psTools::dbExec('
	  ALTER TABLE `@DB_fs2ps_match`
	  ADD INDEX `primary_replacement` (`table`, `entity`, `dto_id`)
    ');
  }
  
  // From 2.9.2
  Fs2psTools::dbExec('ALTER TABLE `@DB_fs2ps_task` MODIFY COLUMN `status_msg` text');
  Fs2psTools::dbExec('ALTER TABLE `@DB_fs2ps_match` MODIFY COLUMN `row_id` varchar(254)');
  
}

function fs2ps_deactivation() {
  // Remove the rewrite rule on deactivation
  global $wp_rewrite;
  $wp_rewrite->flush_rules();
  
  Fs2psTools::dbExec('DROP TABLE IF EXISTS `@DB_fs2ps_task_log`');
  Fs2psTools::dbExec('DROP TABLE IF EXISTS `@DB_fs2ps_task`');
}

function fs2ps_rewrites($wp_rules) {
  // XXX cfillol: Esto no funciona. Puede que sea por la configuración de apache.
  // Otra alternativa es apuntar directamente a wp-content/plugins/fs2ps/service.php
  // aunque esto implicaría dejar de tener disponible el contexto de WP.
  $fs2ps_rules = array(
    "fs2pas?$" => 'index.php?'
  );
  return array_merge($fs2ps_rules, $wp_rules);
}

// Add initialization and activation hooks
add_action('init', 'fs2ps_init');
register_activation_hook("$dir/fs2ps.php", 'fs2ps_activation');
register_deactivation_hook("$dir/fs2ps.php", 'fs2ps_deactivation');


/**
 * custom option and settings
 */
function fs2ps_section_cb( $args ) { }
function fs2ps_text_field_cb( $args ) {
    $options = get_option( 'fs2ps_settings' );
    ?>
	<input 
		type="text" id="<?php echo esc_attr( $args['label_for'] ); ?>"
	 	name="fs2ps_settings[<?php echo esc_attr( $args['label_for'] ); ?>]"
	 	value="<?php echo $options[ $args['label_for'] ]; ?>"
	/>
	<?php
}
function fs2ps_settings_init() {
	register_setting( 'fs2ps', 'fs2ps_settings' );
	add_settings_section(
	    'fs2ps_section', __(
	        '<div class="warn" style="margin-bottom: 20px; font-weight: normal;">
				<h2>INSTRUCCIONES DE USO DE FS2PS</h2>
				<ol style="list-style-type:decimal;">
					<li>
                        Indica un valor en el campo KEY.
                        La KEY es una clave secreta necesaria para asegurar que sólo tú puedes sincronizar tu Factusol con tu WooCommerce.
                        Puedes indicar la KEY que quieras pero después deberás poner exactamente el mismo valor en la configuración del extractor.
                    </li>
					<li>No olvides guardar los cambios para que quede almacenada la nueva KEY.</li>
					<li>Descarga <a href="http://www.festeweb.com/static/downloads/fs2ps-client_2.19.2-64b.exe">el extractor de 64 bits</a> o <a href="http://www.festeweb.com/static/downloads/fs2ps-client_2.19.2.exe">el antiguo de 32 bits</a>  e instálalo en la máquina donde tengas FactuSOL.</a></li>
					<li>
						Ejecuta el extractor de FactuSOL y pulsa el botón "CONFIGURAR" para establecer la ruta a la BD de FactuSOL (<b>MDB_PATH</b>), 
                        la <b>URL</b> de tu Wordpress (<b><script>document.write((function(l) { 
                            var a = l.protocol+"//"+l.hostname+(l.port? ":"+l.port : "");
                            var b = l.pathname.split("/").filter(function (e) { return e; }).slice(0, -2); 
                            return a + (b.length>0? "/"+b.join("/"): "");
                        })(window.location))</script></b>) y la <b>KEY</b> indicada aquí.
					</li>
					<li>No olvides guardar los cambios realizados en el fichero de configuración del extractor.</li>
					<li>Una vez establecida la configuración, pulsa el botón "MIGRAR" para poner a prueba el extractor.</li>
					<li>Puede que el extractor muestre algún error que haya que resolver.</li>
					<li>Si todo fué bien el extractor mostrará la barra de progreso completa y el mensaje correspondiente.</li>
					<li>Comprueba que se han cargado en la tienda online los productos marcados para publicar en Internet en tu FactuSOL y las secciones y familias que los contienen.</li>
					<li>Repite la migración siempre que necesites subir cambios de FactuSOL a WooCommerce.</li>
					<li>Por razones de seguridad se recomienda usar un certificado SSL y cambiar la KEY periódicamente.</li>
				</ol>
			</div>', 
	        'fs2ps' ), 
	    'fs2ps_section_cb', 
	    'fs2ps'
	);
	add_settings_field(
		'fs2ps_key', __( 'KEY', 'fs2ps' ), 'fs2ps_text_field_cb',
		'fs2ps', 'fs2ps_section',
		array(
			'label_for' => 'fs2ps_key',
		)
	);
}
add_action( 'admin_init', 'fs2ps_settings_init' );

// Menu entry
function fs2ps_settings() {
	add_submenu_page(
		'options-general.php',
		'FS2PS: De Factusol a WooCommerce',
		'FS2PS: De Factusol a WooCommerce',
		'manage_options',
		'fs2ps',
		'fs2ps_settings_html'
	);
}
function fs2ps_settings_html() {
	if ( ! current_user_can( 'manage_options' ) ) return;
	settings_errors( 'fs2ps_messages' );
    ?>
    <div class="wrap">
    <h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
    <form action="options.php" method="post">
        <?php
        settings_fields( 'fs2ps' );
        do_settings_sections( 'fs2ps' );
        submit_button( 'Guardar configuración' );
        ?>
    </form>
    </div>
    <?php
}


?>