<?php
/**
 * LICENCIA
 *
 * Este programa se propociona "tal cual", sin garantía de ningún tipo más allá del soporte
 * pactado a la hora de adquirir el programa.
 *
 * En ningún caso los autores o titulares del copyright serán responsables de ninguna
 * reclamación, daños u otras responsabilidades, ya sea en un litigio, agravio o de otro
 * modo, que surja de o en conexión con el programa o el uso u otro tipo de acciones
 * realizadas con el programa.
 *
 * Este programa no puede modificarse ni distribuirse sin el consentimiento expreso del autor.
 *
 *    @author    Carlos Fillol Sendra <festeweb@festeweb.com>
 *    @copyright 2014 Fes-te web! - www.festeweb.com
 *    @license   http://www.festeweb.com/static/licenses/fs2ps_1.1.0.txt
 */


include_once(dirname(__FILE__).'/Fs2psTools.php');
include_once(dirname(__FILE__).'/Fs2psExtractor.php');
include_once(dirname(__FILE__).'/Fs2psMatchers.php');
include_once(dirname(__FILE__).'/Fs2psObjectModels.php');
include_once(dirname(__FILE__).'/Fs2psUpdaters.php');


class Fs2psOrderDependentExtractor extends Fs2psExtractor
{
    protected $ifvalid;
    protected $withmail;
    protected $orders_valid_states;
    protected $orders_nonvalid_states;
    protected $download_orders_ids;
    protected $nif_metakey_sql_in_values;
    protected $orders_discount_preference;
    protected $wc_custom_order_tables;
    protected $hpos_enabled; // get_option( 'woocommerce_feature_custom_order_tables_enabled' )
    protected $price_num_decimals;

    
    protected function reloadCfg() {
        parent::reloadCfg();
        $cfg = $this->task->cfg;
        $download_orders = $cfg->get('DOWNLOAD_ORDERS', '');
        $download_cancelled_orders = $cfg->get('DOWNLOAD_CANCELLED_ORDERS', '');
        $download_refunded_orders = $cfg->get('DOWNLOAD_REFUNDED_ORDERS', '');
        $this->ifvalid = strpos($download_orders, 'ifvalid') !== false;
        $this->withmail = strpos($download_orders, 'withmail') !== false;
               
        $valid_array = [ ];
        if ($download_cancelled_orders) $valid_array[] = 'wc-cancelled';

        $non_valid_array = [ 'wc-failed', 'trash', 'draft', 'auto-draft', 'wc-pending', 'wc-checkout-draft' ];
        if (!$download_cancelled_orders) $non_valid_array[] = 'wc-cancelled';
        if (!$download_refunded_orders) $non_valid_array[] = 'wc-refunded';
        if ($this->ifvalid) $non_valid_array[] = 'wc-on-hold';
        
        $val_nonval_defaults = [
            'VALID' => implode(',', $valid_array),
            'NONVALID' => implode(',', $non_valid_array)
        ];

        foreach ($val_nonval_defaults as $k => $v) {
            $states = $cfg->get('DOWNLOAD_ORDERS_'.$k.'_STATES', $val_nonval_defaults[$k]);
            if (!empty($states)) {
                $matches = null;
                preg_match_all('/[0-9a-z\-]+/', strval($states), $matches);
                $this->{'orders_'.strtolower($k).'_states'} = $matches[0];
            }
        }
        
        if (is_bool($download_orders)) {
            $this->download_orders_ids = array();
        } else {
            $matches = null;
            preg_match_all('/[0-9]+/', strval($download_orders), $matches);
            $this->download_orders_ids = $matches[0];
        }
        
        $this->orders_discount_preference = $cfg->get('ORDERS_DISCOUNT_PREFERENCE', '');
        
        //billing_id_number
        $nif_metakey_str = $cfg->get('ORDER_NIF_METAKEY');
        $this->nif_metakey_sql_in_values = $nif_metakey_str? implode('\',\'', preg_split("/ *, */", $nif_metakey_str)) : '_billing_nif\', \'nif';

        $this->hpos_enabled = Fs2psTools::dbValue("select option_value from @DB_options where option_name='woocommerce_custom_orders_table_enabled'")=='yes';
        $price_num_decimals = Fs2psTools::dbValue('select option_value from @DB_options where option_name="woocommerce_price_num_decimals"');
        $this->price_num_decimals = $price_num_decimals===null? 2 : intval($price_num_decimals);
    }
    
    protected function metaSel($meta_key, $extra='',$order_id='o.ID')
    {
        $hpos = $this->hpos_enabled;
        if ($hpos) {
            return "(select max(meta_value) from @DB_wc_orders_meta where order_id=".$order_id." and meta_key in ('".$meta_key."') ".$extra.")";
        } else {
            return "(select max(meta_value) from @DB_postmeta where post_id=".$order_id." and meta_key in ('".$meta_key."') ".$extra.")";
        }
    }

    protected function getAfterDateWhereCondition()
    {
        $hpos = $this->hpos_enabled;

        $where = $hpos? array('o.type=\'shop_order\'') : array('o.post_type=\'shop_order\'');

        if ($this->withmail) {
            $where[] = $hpos? 'a.email>\'\'' : 'om.meta_value>\'\'';
        }

        if ($this->download_orders_ids) {
            $where[] = 'o.ID in ('.join(',', $this->download_orders_ids).')';
        } else {
            if (!empty($this->task->cmd['after'])) {
                $after_str =  Fs2psTools::date2db(Fs2psTools::dto2date($this->task->cmd['after']));
                $where[] = ($hpos?'o.date_updated_gmt':'o.post_modified').'>\''.$after_str.'\'';
            }
            
            if (!empty($this->task->cmd['created_after'])) {
                $created_after_str =  Fs2psTools::date2db(Fs2psTools::dto2date($this->task->cmd['created_after']));
                $where[] = ($hpos?'o.date_created_gmt':'o.post_date').'>\''.$created_after_str.'\'';
            }
            if (!empty($this->task->cmd['orders_created_after'])) {
                // XXX: Para filtrar customers por fecha de creación de pedido
                $orders_created_after_str =  Fs2psTools::date2db(Fs2psTools::dto2date($this->task->cmd['orders_created_after']));
                $where[] = ($hpos?'o.date_created_gmt':'o.post_date').'>\''.$orders_created_after_str.'\'';
            }
            
            if (!empty($this->task->cmd['until'])) {
                $until_str =  Fs2psTools::date2db(Fs2psTools::dto2date($this->task->cmd['until']));
                $where[] = ($hpos?'o.date_updated_gmt':'o.post_modified').'<=\''.$until_str.'\'';
            }
            
            if ($this->orders_valid_states) {
                $where[] = ($hpos?'o.status':'o.post_status').' in ('.Fs2psTools::dbInStr($this->orders_valid_states).')';
            }
            if ($this->orders_nonvalid_states) {
                $where[] = ($hpos?'o.status':'o.post_status').' not in ('.Fs2psTools::dbInStr($this->orders_nonvalid_states).')';
            }
        }
        
        return join(" and ", $where);
    }
}

class Fs2psCustomerExtractor extends Fs2psOrderDependentExtractor
{
    
    protected $download_customers;
    protected $noorder;
    protected $noaddress;
    protected $optional_fields = array('address2');
    protected $orders_extra_metas;
    protected $customers_extra_metas;
    
    protected function reloadCfg() {
        parent::reloadCfg();
        $cfg = $this->task->cfg;
        $this->download_customers = $cfg->get('DOWNLOAD_CUSTOMERS', '');
        $this->noaddress = strpos($this->download_customers, 'noaddress') !== false;
        $this->noorder = $this->noaddress || strpos($this->download_customers, 'noorder') !== false;
        $this->orders_extra_metas = $cfg->get('ORDERS_EXTRA_METAS', '');
        $this->customers_extra_metas = $cfg->get('CUSTOMERS_EXTRA_METAS', '');
    }
    
    protected function buildSql()
    {
        $hpos = $this->hpos_enabled;
        
        $orders_sql = '
            SELECT
                o.ID as order_id,
                '.($hpos? 'o.customer_id' : 'omu.meta_value').' as customer_id,
                '.($hpos? 'o.date_created_gmt' : 'o.post_date').' as date_add,
                '.($hpos? 'o.date_updated_gmt' : 'o.post_modified').' as date_upd,
                false as is_date_timestamp,
                '.($hpos? 'a.first_name' : $this->metaSel('_billing_first_name')).' as firstname,
                '.($hpos? 'a.last_name' : $this->metaSel('_billing_last_name')).' as lastname,
                '.($hpos? 'a.email' : $this->metaSel('_billing_email')).' as email,
                '.($hpos? 'a.company' : $this->metaSel('_billing_company')).' as company,
                '.$this->metaSel($this->nif_metakey_sql_in_values, 'and meta_value<>\'\' limit 1').' as dni,
                '.($hpos? 'a.address_1' : $this->metaSel('_billing_address_1')).' as address1,
                '.($hpos? 'a.address_2' : $this->metaSel('_billing_address_2')).' as address2,
                '.($hpos? 'a.postcode' : $this->metaSel('_billing_postcode')).' as postcode,
                '.($hpos? 'a.city' : $this->metaSel('_billing_city')).' as city,
                '.($hpos? 'a.phone' : $this->metaSel('_billing_phone')).' as phone,
                (select meta_value from @DB_usermeta where user_id='.($hpos? 'o.customer_id' : 'omu.meta_value').' and meta_key=\'@DB_capabilities\') as roles,
                '.($hpos? 'a.state' : $this->metaSel('_billing_state')).' as state_iso2,
                '.($hpos? 'a.country' : $this->metaSel('_billing_country')).' as country_iso2
            FROM
                '.($hpos? '@DB_wc_orders' : '@DB_posts').' o
                '.($hpos?
                    'left join @DB_wc_order_addresses a on a.order_id=o.id and a.address_type=\'billing\'' : 
                    '
                        left join @DB_postmeta om on om.post_id=o.ID and om.meta_key=\'_billing_email\'
                        left join @DB_postmeta omu on omu.post_id=o.ID and omu.meta_key=\'_customer_user\'
                    '
                ).'
            WHERE
                '.parent::getAfterDateWhereCondition().'
        ';

        if($this->noaddress || $this->noorder){
            
            $customers_sql = '
                SELECT
                    null as order_id,
                    u.ID as customer_id,
                    u.created as date_add,
                    FROM_UNIXTIME(u.modified) as date_upd,
                    (select max(meta_value) from @DB_usermeta where user_id=u.ID and meta_key=\''.($this->noaddress? '' : 'billing_').'first_name\') as firstname,
                    (select max(meta_value) from @DB_usermeta where user_id=u.ID and meta_key=\''.($this->noaddress? '' : 'billing_').'last_name\') as lastname,
                    coalesce((select max(meta_value) from @DB_usermeta where user_id=u.ID and meta_key=\'billing_email\'), billing_email) as email,
                    (select max(meta_value) from @DB_usermeta where user_id=u.ID and meta_key=\'billing_company\') as company,
                    (select max(meta_value) from @DB_usermeta where user_id=u.ID and meta_key in (\''.$this->nif_metakey_sql_in_values.'\') and meta_value<>\'\' limit 1) as dni,
                    (select max(meta_value) from @DB_usermeta where user_id=u.ID and meta_key=\'billing_address_1\') as address1,
                    (select max(meta_value) from @DB_usermeta where user_id=u.ID and meta_key=\'billing_address_2\') as address2,
                    (select max(meta_value) from @DB_usermeta where user_id=u.ID and meta_key=\'billing_postcode\') as postcode,
                    (select max(meta_value) from @DB_usermeta where user_id=u.ID and meta_key=\'billing_city\') as city,
                    (select max(meta_value) from @DB_usermeta where user_id=u.ID and meta_key=\'billing_phone\') as phone,
                    (select meta_value from @DB_usermeta where user_id=u.ID and meta_key=\'@DB_capabilities\') as roles, -- cfillol: select DISTINCT meta_value ... as roles?
                    (select max(meta_value) from @DB_usermeta where user_id=u.ID and meta_key=\'billing_state\') as state_iso2,
                    (select max(meta_value) from @DB_usermeta where user_id=u.ID and meta_key=\'billing_country\') as country_iso2
                FROM
                    (
                        select
                        u.ID,
                        u.user_registered as created,
                        u.user_email as billing_email,
                        (select max(meta_value) from @DB_usermeta where meta_key=\'last_update\' and user_id=u.ID) as modified
                        from @DB_users u
                    ) u
                WHERE
                    '.$this->getAfterDateWhereCondition().'
            ';

            $sql_row = '
                select 
                    max(order_id) as order_id,
                    max(customer_id) as customer_id,
                    min(date_add) as date_add,
                    max(date_upd) as date_upd,
                    firstname,
                    lastname,
                    email,
                    company,
                    dni,
                    address1,
                    address2,
                    postcode,
                    city,
                    phone,
                    roles,
                    state_iso2,
                    country_iso2
                from (
                    select
                        o.order_id,
                        if(o.order_id is null, u.customer_id, o.customer_id) as customer_id,
                        if(o.order_id is null, u.date_add, o.date_add) as date_add,
                        if(o.order_id is null, u.date_upd, o.date_upd) as date_upd,
                        if(o.order_id is null, u.firstname, o.firstname) as firstname,
                        if(o.order_id is null, u.lastname, o.lastname) as lastname,
                        if(o.order_id is null, u.email, o.email) as email,
                        if(o.order_id is null, u.company, o.company) as company,
                        if(o.order_id is null, u.dni, o.dni) as dni,
                        if(o.order_id is null, u.address1, o.address1) as address1,
                        if(o.order_id is null, u.address2, o.address2) as address2,
                        if(o.order_id is null, u.postcode, o.postcode) as postcode,
                        if(o.order_id is null, u.city, o.city) as city,
                        if(o.order_id is null, u.phone, o.phone) as phone,
                        if(o.order_id is null, u.roles, o.roles) as roles,
                        if(o.order_id is null, u.state_iso2, o.state_iso2) as state_iso2,
                        if(o.order_id is null, u.country_iso2, o.country_iso2) as country_iso2
                    from (
                        '.$customers_sql.'
                    ) u
                    left join (
                        '.$orders_sql.'
                    ) o on o.email=u.email and (o.dni=u.dni or (u.dni is null or u.dni=\'\') )
                ) u
                GROUP BY firstname,	lastname, email, company, dni, address1, address2, postcode, city, phone, roles, state_iso2, country_iso2
            ';
            
        } else {
            $sql_row = $orders_sql;
        }
        
        
        $select = [];
        if (!empty($this->orders_extra_metas)) { // ORDERS_EXTRA_METAS
            foreach (explode(',', $this->orders_extra_metas) as $meta) {
                array_push($select, $this->metaSel($meta, '', 'r.order_id').' as '.$meta);
            }
        }
        if (!empty($this->customers_extra_metas)) { // CUSTOMERS_EXTRA_METAS
            foreach (explode(',', $this->customers_extra_metas) as $meta) {
                array_push($select, "(select max(meta_value) from @DB_usermeta where user_id=customer_id and meta_key='".$meta."') as ".$meta);
            }
        }

        // Devolvemos información estandár + metas
        return '
            SELECT 
                r.*
                '.(!empty($select)?','.implode(',', $select):'').'
            FROM (
                '.$sql_row.'
            ) r
            ORDER BY date_upd
        ';
    }
    
    protected function getAfterDateWhereCondition()
    {
        if (!$this->noaddress && !$this->noorder) return parent::getAfterDateWhereCondition();
            
        $where = array();
        
        if ($this->noorder && !$this->noaddress) $where[] = 'billing_email>\'\'';
        
        if (!empty($this->task->cmd['after'])) {
            $after = strtotime($this->task->cmd['after']);
            $where[] = 'u.modified>\''.$after.'\'';
        }
        
        if (!empty($this->task->cmd['created_after'])) {
            $created_after_str =  Fs2psTools::date2db(Fs2psTools::dto2date($this->task->cmd['created_after']));
            $where[] = 'u.created>\''.$created_after_str.'\'';
        }
        
        if (!empty($this->task->cmd['until'])) {
            $until_str = strtotime($this->task->cmd['until']);
            $where[] = 'u.modified=\''.$until_str.'\'';
        }
        
        return join(" and ", $where);
    }
    
    protected function row2dto($row)
    {
        $dto = array(
            'user' => $row['email'],
            'created' => is_numeric($row['date_add'])? date('Y-m-d H:i:s',$row['date_add']) : $row['date_add'],
            'updated' => is_numeric($row['date_upd'])? date('Y-m-d H:i:s',$row['date_upd']) : $row['date_upd'],
            'company' => $row['company'],
            'nif' => $row['dni'],
            'vat_number' => '', // $row['vat_number'],
            'firstname' => $row['firstname'],
            'lastname' => $row['lastname'],
            'email' => $row['email'],
            'address' => $row['address1'],
            'postcode' => $row['postcode'],
            'city' => $row['city'],
            'state' => WC()->countries->states[$row['country_iso2']][$row['state_iso2']],
            'state_iso2' => $row['state_iso2'],
            'country' => WC()->countries->countries[$row['country_iso2']],
            'country_iso2' => $row['country_iso2'],
            'phone' => $row['phone'],
            'mobile' => '',
        );
        
        foreach ($this->optional_fields as $of) {
            if (!empty($row[$of])) $dto[$of] = $row[$of];
        }

        if (!empty($this->orders_extra_metas) || !empty($this->customers_extra_metas)){
            $extra_metas = [];
            if (!empty($this->orders_extra_metas)) {
                foreach (explode(',', $this->orders_extra_metas) as $meta) {
                    if (isset($row[$meta])) $extra_metas[$meta] = maybe_unserialize($row[$meta]);
                }
            }
            if (!empty($this->customers_extra_metas)) {
                foreach (explode(',', $this->customers_extra_metas) as $meta) {
                    if (isset($row[$meta])) $extra_metas[$meta] = maybe_unserialize($row[$meta]);
                }
            }
            $dto['extra_metas'] = $extra_metas;
        }
        
        
        $wp_roles = maybe_unserialize($row['roles']);
        $dto['roles'] = empty($wp_roles)? array() : array_keys($wp_roles);
        
        return $dto;
    }
    
}

class Fs2psCustomerAddressExtractor extends Fs2psOrderDependentExtractor
{
    public function __construct($task, $name)
    {
        parent::__construct($task, $name);
        //$this->groupMatcher = Fs2psMatcherFactory::get($task, 'customer_addresses');
    }

    protected function buildSql()
    {
        $hpos = $this->hpos_enabled;

        return '
            SELECT * FROM (

                SELECT
                    o.ID as order_id,
                    '.($hpos? 'o.date_created_gmt' : 'o.post_date').' as date_add,
                    '.($hpos? 'o.date_updated_gmt' : 'o.post_modified').' as date_upd,
                    '.($hpos? 'a.first_name' : $this->metaSel('_billing_first_name')).' as firstname,
                    '.($hpos? 'a.last_name' : $this->metaSel('_billing_last_name')).' as lastname,
                    '.($hpos? 'a.email' : $this->metaSel('_billing_email')).' as email,
                    '.($hpos? 'a.company' : $this->metaSel('_billing_company')).' as company,
                    '.$this->metaSel($this->nif_metakey_sql_in_values, 'and meta_value<>\'\' limit 1').' as dni,
                    \'\' as vat_number,
                    '.($hpos? 'a.address_1' : $this->metaSel('_billing_address_1')).' as address1,
                    '.($hpos? 'a.address_2' : $this->metaSel('_billing_address_2')).' as address2,
                    '.($hpos? 'a.postcode' : $this->metaSel('_billing_postcode')).' as postcode,
                    '.($hpos? 'a.city' : $this->metaSel('_billing_city')).' as city,
                    '.($hpos? 'a.phone' : $this->metaSel('_billing_phone')).' as phone,
                    \'\' as phone_mobile,
                    '.($hpos? 'a.state' : $this->metaSel('_billing_state')).' as state_iso2,
                    '.($hpos? 'a.country' : $this->metaSel('_billing_country')).' as country_iso2
                    '.(!empty($select)?','.implode(',', $select):'').'
                FROM
                    '.($hpos? '@DB_wc_orders' : '@DB_posts').' o
                    '.($hpos?
                        'left join @DB_wc_order_addresses a on a.order_id=o.id and a.address_type=\'billing\'' : 
                        'left join @DB_postmeta om on om.post_id=o.ID and om.meta_key=\'_billing_email\''
                    ).'
                WHERE '.$this->getAfterDateWhereCondition().'

                UNION 

                SELECT
                    o.ID as order_id,
                    '.($hpos? 'o.date_created_gmt' : 'o.post_date').' as date_add,
                    '.($hpos? 'o.date_updated_gmt' : 'o.post_modified').' as date_upd,
                    '.($hpos? 'sa.first_name' : $this->metaSel('_shipping_first_name')).' as firstname,
                    '.($hpos? 'sa.last_name' : $this->metaSel('_shipping_last_name')).' as lastname,
                    '.($hpos? 'a.email' : $this->metaSel('_billing_email')).' as email,
                    '.($hpos? 'sa.company' : $this->metaSel('_shipping_company')).' as company,
                    '.$this->metaSel($this->nif_metakey_sql_in_values, 'and meta_value<>\'\' limit 1').' as dni,
                    \'\' as vat_number,
                    '.($hpos? 'sa.address_1' : $this->metaSel('_shipping_address_1')).' as address1,
                    '.($hpos? 'sa.address_2' : $this->metaSel('_shipping_address_2')).' as address2,
                    '.($hpos? 'sa.postcode' : $this->metaSel('_shipping_postcode')).' as postcode,
                    '.($hpos? 'sa.city' : $this->metaSel('_shipping_city')).' as city,
                    '.($hpos? 'sa.phone' : $this->metaSel('_shipping_phone')).' as phone,
                    \'\' as phone_mobile,
                    '.($hpos? 'sa.state' : $this->metaSel('_shipping_state')).' as state_iso2,
                    '.($hpos? 'sa.country' : $this->metaSel('_shipping_country')).' as country_iso2
                    '.(!empty($select)?','.implode(',', $select):'').'
                FROM
                    '.($hpos? '@DB_wc_orders' : '@DB_posts').' o
                    '.($hpos?
                        '
                            left join @DB_wc_order_addresses a on a.order_id=o.id and a.address_type=\'billing\'
                            left join @DB_wc_order_addresses sa on sa.order_id=o.id and sa.address_type=\'shipping\'
                        ' : 
                        'left join @DB_postmeta om on om.post_id=o.ID and om.meta_key=\'_billing_email\''
                    ).'
                WHERE '.$this->getAfterDateWhereCondition().'

            ) a
            WHERE address1 is not null
            ORDER BY date_upd, order_id
        ';
    }

    protected function row2dto($row)
    {
        $dto = array(
            'user' => $row['email'], // Hi ha que traure el id_customer
            'created' => $row['date_add'],
            'updated' => date('Y-m-d H:i:s',strtotime($row['date_upd'])),
            'company' => $row['company'],
            'nif' => $row['dni'],
            'vat_number' => '', // $row['vat_number'],
            'firstname' => $row['firstname'],
            'lastname' => $row['lastname'],
            'email' => $row['email'],
            'address' => $row['address1'],
            'address2' => $row['address2'],
            'postcode' => $row['postcode'],
            'city' => $row['city'],
            'state' => WC()->countries->states[$row['country_iso2']][$row['state_iso2']],
            'state_iso2' => $row['state_iso2'],
            'country' => WC()->countries->countries[$row['country_iso2']],
            'country_iso2' => $row['country_iso2'],
            'phone' => $row['phone'],
            'mobile' => '',
        );
        return $dto;
    }
}

class Fs2psOrderExtractor extends Fs2psOrderDependentExtractor
{
    
    protected $optional_fields = array('address2', 'saddress2');
    protected $ref_metakey;
    protected $extra_metas;
    protected $item_extra_metas;
    protected $orders_consider_tax_exempt_if_zero_line_tax;
    protected $customers_extra_metas;
    
    protected function reloadCfg() {
        parent::reloadCfg();
        $cfg = $this->task->cfg;
        $this->ref_metakey = $cfg->get('ORDER_REF_METAKEY', '');
        $this->extra_metas = $cfg->get('ORDERS_EXTRA_METAS', '');
        $this->item_extra_metas = $cfg->get('ORDER_ITEM_EXTRA_METAS', '');
        $this->orders_consider_tax_exempt_if_zero_line_tax = $cfg->get('ORDERS_CONSIDER_TAX_EXEMPT_IF_ZERO_LINE_TAX', '');
        $this->customers_extra_metas = $cfg->get('CUSTOMERS_EXTRA_METAS', '');
    }
    
    protected function buildSql()
    {
        
        /*
         _cart_discount	16.97			Base del escuento total
         _cart_discount_tax	3.56		IVA del descuento total
         _order_shipping	3.95			Base del transporte
         _order_shipping_tax	0			IVA del transporte
         _order_tax	32.08				IVA total del pedido
         _order_total	188.77			Total del pedido (lo que se paga, con IVA y descuentos)
         */

        $hpos = $this->hpos_enabled;

        $coupon_lookup = '\' \'';
        if($GLOBALS['wp_version']>="6.0"){
            $coupon_lookup = "(
                select group_concat(woi.order_item_name)
                from @DB_woocommerce_order_items woi
                where woi.order_item_type='coupon' and woi.order_id=o.id
            )";

        }else{
            //Comportamiento viejo, mantenemos por compatibilidad con Wordpress viejos.
            $table_coupon_lookup = Fs2psTools::dbValue(
                'SHOW TABLES LIKE \'@DB_wc_order_coupon_lookup\''
            );
            if(!empty($table_coupon_lookup)){
                $coupon_lookup = '(
                    SELECT group_concat(wp.post_title)
                    FROM @DB_wc_order_coupon_lookup cl
                    inner join @DB_posts wp on wp.ID=cl.coupon_id
                    where wp.post_type="shop_coupon" and cl.order_id=o.ID
                    group by cl.order_id
                )';
            }
        }
        
        $select = [];
        if (!empty($this->extra_metas)) {
            foreach (explode(',', $this->extra_metas) as $meta) {
                array_push($select, $this->metaSel($meta).' as '.$meta);
            }
        }

        # ORDER_ITEM_EXTRA_METAS
        if (!empty($this->item_extra_metas)) {
            foreach (explode(',', $this->item_extra_metas) as $meta) {
                $metakey = Fs2psTools::str2DbAlias($meta);
                array_push($select, "(select max(meta_value) from @DB_woocommerce_order_itemmeta oim inner join @DB_woocommerce_order_items oi on oi.order_item_id=oim.order_item_id where oi.order_id=o.ID and meta_key='".$meta."') as ".$metakey);
            }
        }

        # CUSTOMERS_EXTRA_METAS
        if (!empty($this->customers_extra_metas)) {
            foreach (explode(',', $this->customers_extra_metas) as $meta) {
                array_push($select, "(select max(meta_value) from @DB_usermeta where user_id=".($hpos? 'o.customer_id' : 'omu.meta_value')." and meta_key='".$meta."') as ".$meta);
            }
        }
        
        return '
			SELECT
				o.ID as id_order,
				'.(!empty($this->ref_metakey)? $this->metaSel($this->ref_metakey) : '\'\'').' as reference,
				null as invoice_number,
				'.($hpos? 'o.date_created_gmt' : 'o.post_date').' as date_add,
                '.($hpos? 'o.status' : 'o.post_status').' as order_status,
				'.($hpos? 'o.date_updated_gmt' : 'o.post_modified').' as date_upd,
                '.($hpos? 'o.customer_note' : 'o.post_excerpt').' as note,

                '.($hpos? 'o.total_amount' : $this->metaSel('_order_total')).' as _order_total,
                '.($hpos? 'o.tax_amount' : $this->metaSel('_order_tax')).' as _order_tax,

                '.($hpos? 'od.discount_total_amount' : $this->metaSel('_cart_discount')).' as _cart_discount,
				'.($hpos? 'od.discount_tax_amount' : $this->metaSel('_cart_discount_tax')).' as _cart_discount_tax,
                '.($hpos? 'od.shipping_total_amount' : $this->metaSel('_order_shipping')).' as _order_shipping,
                '.($hpos? 'od.shipping_tax_amount' : $this->metaSel('_order_shipping_tax')).' as _order_shipping_tax,

                '.($hpos? 'a.first_name' : $this->metaSel('_billing_first_name')).' as firstname,
                '.($hpos? 'a.last_name' : $this->metaSel('_billing_last_name')).' as lastname,
                '.($hpos? 'a.email' : $this->metaSel('_billing_email')).' as email,
                '.($hpos? 'a.company' : $this->metaSel('_billing_company')).' as company,
                '.$this->metaSel($this->nif_metakey_sql_in_values, 'and meta_value<>\'\' limit 1').' as dni,
                \'\' as vat_number,
                '.($hpos? 'a.address_1' : $this->metaSel('_billing_address_1')).' as address1,
                '.($hpos? 'a.address_2' : $this->metaSel('_billing_address_2')).' as address2,
                '.($hpos? 'a.postcode' : $this->metaSel('_billing_postcode')).' as postcode,
                '.($hpos? 'a.city' : $this->metaSel('_billing_city')).' as city,
                '.($hpos? 'a.phone' : $this->metaSel('_billing_phone')).' as phone,
                \'\' as phone_mobile,
                '.($hpos? 'a.state' : $this->metaSel('_billing_state')).' as state_iso2,
                '.($hpos? 'a.country' : $this->metaSel('_billing_country')).' as country_iso2,

                '.(!empty($select)?implode(',', $select).',':'').'

                '.($hpos? 'sa.first_name' : $this->metaSel('_shipping_first_name')).' as sfirstname,
                '.($hpos? 'sa.last_name' : $this->metaSel('_shipping_last_name')).' as slastname,
                '.($hpos? 'sa.email' : $this->metaSel('_shipping_email')).' as semail,
                '.($hpos? 'sa.address_1' : $this->metaSel('_shipping_address_1')).' as saddress1,
                '.($hpos? 'sa.address_2' : $this->metaSel('_shipping_address_2')).' as saddress2,
                '.($hpos? 'sa.postcode' : $this->metaSel('_shipping_postcode')).' as spostcode,
                '.($hpos? 'sa.city' : $this->metaSel('_shipping_city')).' as scity,
                '.($hpos? 'sa.phone' : $this->metaSel('_shipping_phone')).' as sphone,
                \'\' as sphone_mobile,
                '.($hpos? 'sa.state' : $this->metaSel('_shipping_state')).' as sstate_iso2,
                '.($hpos? 'sa.country' : $this->metaSel('_shipping_country')).' as scountry_iso2,
                (select meta_value from @DB_usermeta where user_id='.($hpos? 'o.customer_id' : 'omu.meta_value').' and meta_key=\'@DB_capabilities\') as roles,

                '.$coupon_lookup.' as coupons,

                '.($hpos? 'o.payment_method' : $this->metaSel('_payment_method')).' as payment,

                (
                    SELECT GROUP_CONCAT(distinct im.meta_value)
                    FROM @DB_woocommerce_order_items i
                    INNER JOIN @DB_woocommerce_order_itemmeta im on im.order_item_id=i.order_item_id
                    WHERE i.order_id=o.ID and i.order_item_type=\'shipping\' and im.meta_key=\'method_id\'
                ) as carriers,
                (
                    SELECT GROUP_CONCAT(i.order_item_name)
                    FROM @DB_woocommerce_order_items i
                    WHERE i.order_id=o.ID and i.order_item_type=\'shipping\'
                ) as carrier_descrip
                
	        FROM

                '.($hpos? '@DB_wc_orders' : '@DB_posts').' o
                '.($hpos? 'inner join @DB_wc_order_operational_data od on od.order_id=o.ID' : '').'
                '.($hpos? '
                    left join @DB_wc_order_addresses a on a.order_id=o.id and a.address_type=\'billing\'
                    left join @DB_wc_order_addresses sa on sa.order_id=o.id and sa.address_type=\'shipping\'
                ' : '
                    left join @DB_postmeta om on om.post_id=o.ID and om.meta_key=\'_billing_email\'
                    left join @DB_postmeta omu on omu.post_id=o.ID and omu.meta_key=\'_customer_user\'
                ').'

	        WHERE
	            '.$this->getAfterDateWhereCondition().'

            ORDER BY '.($hpos? 'o.date_updated_gmt' : 'o.post_modified').', o.ID
		';
    }
    
    protected function getOrderTotals($row)
    {
        if (!empty($this->orders_consider_tax_exempt_if_zero_line_tax)) {
            $sql_tax = 'IF(0<(select meta_value from @DB_woocommerce_order_itemmeta where order_item_id=oi_lines.order_item_id and meta_key=\'_line_tax\'), (select sum(distinct tax_rate) from @DB_woocommerce_tax_rates where tax_rate_class=oim_tax_class.meta_value), 0)';
        } else {
            $sql_tax = '(select sum(distinct tax_rate) from @DB_woocommerce_tax_rates where tax_rate_class=oim_tax_class.meta_value)';
        }

        $totals_rows = Fs2psTools::dbSelect('
            SELECT 
                tax, 
                sum(ifnull(line_base, line_base_with_discount)) as line_base,
                sum(ifnull(line_base - line_base_with_discount, 0)) as discount,
                sum(line_tax)  as line_tax
            FROM (			
               SELECT 
                    '.$sql_tax.' as tax,
                    (select round(max(meta_value),'.$this->price_num_decimals.') from @DB_woocommerce_order_itemmeta where order_item_id=oi_lines.order_item_id and meta_key=\'_line_total\') as line_base_with_discount,
                    (select round(max(meta_value),'.$this->price_num_decimals.') from @DB_woocommerce_order_itemmeta where order_item_id=oi_lines.order_item_id and meta_key=\'_line_subtotal\') as line_base,
                    (select round(max(meta_value),'.$this->price_num_decimals.') from @DB_woocommerce_order_itemmeta where order_item_id=oi_lines.order_item_id and meta_key=\'_line_tax\') as line_tax
                FROM
                    @DB_posts o
                    -- lineas de producto
                    inner join @DB_woocommerce_order_items oi_lines on oi_lines.order_id=o.ID and oi_lines.order_item_type in (\'line_item\',\'fee\')
                    inner join @DB_woocommerce_order_itemmeta oim_tax_class on oim_tax_class.order_item_id=oi_lines.order_item_id and oim_tax_class.meta_key=\'_tax_class\'
    			where
    			    o.ID='.$row['id_order'].'
            ) t
            GROUP BY tax
            ORDER BY tax desc
		');
        
        $dec = 1000; // decimales de precisión para impuestos
        
        $taxes_by_rate = array();
        $lines_tax_amounts_by_tax = array();
        $lines_bases_by_tax = array();
        $discount_bases_by_tax = array();
        $shipping_tax_amounts_by_tax = array();
        $shipping_bases_by_tax = array();
        
        $carrier_tax_rate = null;
        if ($row['total_shipping_tax_excl']>0) {
            $carrier_tax_rate = floatval($row['carrier_tax_rate'])*100.0;
            $carrier_tax_rate_key = intval($carrier_tax_rate * $dec);
            $taxes_by_rate[$carrier_tax_rate_key] = $carrier_tax_rate;
            $lines_tax_amounts_by_tax[$carrier_tax_rate_key] = 0;
            $lines_bases_by_tax[$carrier_tax_rate_key] = 0;
            $discount_bases_by_tax[$carrier_tax_rate_key] = 0;
            $shipping_tax_amounts_by_tax[$carrier_tax_rate_key] = 0;
            $shipping_bases_by_tax[$carrier_tax_rate_key] = 0;
        }
        
        $total_products_base = floatval($row['total_products']);
        foreach ($totals_rows as $totals_row)
        {
            $rate = floatval($totals_row['tax']);
            $rate_key = intval($rate * $dec);
            $taxes_by_rate[$rate_key] = $rate;
            $lines_bases_by_tax[$rate_key] = floatval($totals_row['line_base']);
            $lines_tax_amounts_by_tax[$rate_key] = floatval($totals_row['line_tax']);
            $discount_bases_by_tax[$rate_key] = floatval($totals_row['discount']);
            
            // Nos aseguramos de que estén inicializadas a 0 otras tasas distintas a la del transporte
            $shipping_tax_amounts_by_tax[$rate_key] = 0;
            $shipping_bases_by_tax[$rate_key] = 0;
        }
        if (!is_null($carrier_tax_rate)) {
            $shipping_tax_amounts_by_tax[$carrier_tax_rate_key] = floatval($row['total_shipping_tax_incl']) - floatval($row['total_shipping_tax_excl']);
            $shipping_bases_by_tax[$carrier_tax_rate_key] = floatval($row['total_shipping_tax_excl']);
        }
        
        $taxes = array();
        $lines_tax_amounts = array();
        $lines_bases = array();
        $discount_bases = array();
        $shipping_tax_amounts = array();
        $shipping_bases = array();
        foreach ($taxes_by_rate as $rate_key => $val)
        {
            $taxes[] = $rate_key/$dec;
            $lines_tax_amounts[] = $lines_tax_amounts_by_tax[$rate_key];
            $lines_bases[] = $lines_bases_by_tax[$rate_key];
            $discount_bases[] = $discount_bases_by_tax[$rate_key];
            $shipping_tax_amounts[] = $shipping_tax_amounts_by_tax[$rate_key];
            $shipping_bases[] = $shipping_bases_by_tax[$rate_key];
        }

        $total = floatval($row['total_paid_tax_incl']);

        if($this->orders_discount_preference == 'lines'){
            //Gestionamos descuentos en la lineas, ignoramos en el pedido
            $discount_bases = array_fill(0, sizeof($taxes), 0);
        }
        
        /* cfillol: Dejamos de hacer correcciones y permitimos que aflore el error de cálculo en lugar de esconderlo para descubrir (y tratar de solucionar) la raíz del problema
         // Correcciones contables. ¿Que sucede si hay descuadres?
         $total_calc = (
         (array_sum($lines_bases) + array_sum($shipping_bases)) - array_sum($discount_bases) +
         (array_sum($lines_tax_amounts) + array_sum($shipping_tax_amounts))
         );
         $error = round($total_calc - $total, 2); // redondeamos xq a veces se generan periodos aunque sean sumas y restas :/
         if ($error>0) {
         // Si el descuadre es positivo, lo descontamos del total.
         // Nota: Esto puede provocar que se pague más IVA del necesario.
         foreach ($lines_bases as $i => $base) {
         if (($base-$discount_bases[$i]) >= $error) {
         $discount_bases[$i] += $error;
         break;
         }
         }
         }
         else if ($error<0) {
         // Descuadres en Prestashop?! Puede que el usuario pagara más de lo debido.
         // No debería suceder a menos que exista un bug en los cálculos en Prestashop (ej: PS 1.6.0.9)
         // o exista un bug en el conector ...
         $total = $total + $error;
         }
         */
        
        return array(
            'taxes' => $taxes,
            'lines_tax_amounts' => $lines_tax_amounts,
            'lines_bases' => $lines_bases,
            'discount_bases' => $discount_bases,
            'shipping_tax_amounts' => $shipping_tax_amounts,
            'shipping_bases' => $shipping_bases,
            'total' => $total
        );
    }
    
    private function isValidStatus($state)
    {
        if (!empty($this->orders_valid_states) && in_array($state, $this->orders_valid_states)) return true;
        else if (!empty($this->orders_valid_states) && in_array($state, $this->orders_nonvalid_states)) return false;
        else return true; // por defecto devolveremos true
    }
    
    protected function row2dto($row)
    {
        
        $row['total_products'] = $row['_order_total'] - $row['_order_tax'] - $row['_order_shipping'];
        $row['total_paid_tax_incl'] = $row['_order_total'];
        $row['carrier_tax_rate'] = $row['_order_shipping_tax']>0? Fs2psTools::ps_round($row['_order_shipping_tax']/$row['_order_shipping'], 2) : 0.0;
        $row['total_shipping_tax_incl'] = $row['_order_shipping_tax'] + $row['_order_shipping'];
        $row['total_shipping_tax_excl'] = $row['_order_shipping'];
        $row['total_discounts_tax_excl'] = 0.0; // = $row['_cart_discount']; No hace falta tener en cuenta descuento aquí ... Ya se tiene en cuenta en cada linea
        
        $totals = $this->getOrderTotals($row);
        $carriers = explode(',', $row['carriers']);
        
        $dto = array(
            'id' => intval($row['id_order']),
            'ref' => $row['reference'],
            'invoice' => $row['invoice_number'],
            //'invoice' => intval($row['id_order_invoice']),
            'created' => $row['date_add'],
            'updated' => $row['date_upd'],
            'taxes' => $totals['taxes'],
            'discount_bases' => $totals['discount_bases'],
            'lines_tax_amounts' => $totals['lines_tax_amounts'],
            'lines_bases' => $totals['lines_bases'],
            'shipping_tax_amounts' => $totals['shipping_tax_amounts'],
            'shipping_bases' => $totals['shipping_bases'],
            'total' => $totals['total'],
            
            'company' => empty($row['company'])? $row['firstname'].' '.$row['lastname'] : $row['company'],
            'user' => $row['email'],
            'nif' => $row['dni'],
            'vat_number' => $row['vat_number'],
            
            'address' => $row['address1'],
            'address2' => $row['address2'],
            'postcode' => $row['postcode'],
            'city' => $row['city'],
            'state' => WC()->countries->states[$row['country_iso2']][$row['state_iso2']],
            'country' => WC()->countries->countries[$row['country_iso2']],
            'country_iso2' => $row['country_iso2'],
            'phone' => $row['phone'],
            'mobile' => $row['phone_mobile'],
            'email' => $row['email'],
            'firstname' => $row['firstname'],
            'lastname' => $row['lastname'],
            'company' => $row['company'],
            
            'saddress' => $row['saddress1'],
            'saddress2' => $row['saddress2'],
            'spostcode' => $row['spostcode'],
            'scity' => $row['scity'],
            'sstate' => WC()->countries->states[$row['scountry_iso2']][$row['sstate_iso2']],
            'scountry' => WC()->countries->countries[$row['scountry_iso2']],
            'scountry_iso2' => $row['scountry_iso2'],
            'sphone' => $row['sphone'],
            'smobile' => $row['sphone_mobile'],
            'semail' => $row['semail'],
            'sfirstname' => $row['sfirstname'],
            'slastname' => $row['slastname'],
            //'scompany' => $row['scompany'], // Existe para la dirección de envío? No ...
            
            'status' => $row['order_status'],
            'valid' => $this->isValidStatus($row['order_status']),
            //'valid' => intval($row['valid'])==1,
            'payment' => $row['payment'],
            
            'carrier' => $carriers[0],
            'carriers' => $carriers,
            'carrier_descrip' => $row['carrier_descrip']

        );
        
        foreach ($this->optional_fields as $of) {
            if (!empty($row[$of])) $dto[$of] = $row[$of];
        }
        
        if (!empty($row['note'])) {
            $dto['note'] = $row['note'];
        }

        $wp_roles = maybe_unserialize($row['roles']);
        $dto['roles'] = empty($wp_roles)? array() : array_keys($wp_roles);
        
        if (!empty($this->extra_metas) || !empty($this->item_extra_metas) || !empty($this->customers_extra_metas)) {
            $extra_metas = [];

            foreach (explode(',', $this->extra_metas) as $meta) {
                if (isset($row[$meta])) $extra_metas[$meta] = maybe_unserialize($row[$meta]);
            }

            foreach (explode(',', $this->item_extra_metas) as $meta) {
                $meta = Fs2psTools::str2DbAlias($meta);
                if (isset($row[$meta])) $extra_metas[$meta] = maybe_unserialize($row[$meta]);
            }

            foreach (explode(',', $this->customers_extra_metas) as $meta) {
                if (isset($row[$meta])) $extra_metas[$meta] = maybe_unserialize($row[$meta]);
            }

            $dto['extra_metas'] = $extra_metas;
        }
        
        // Obtenemos array de cupones descartando vacíos si los hubiera
        $coupons = array_filter(preg_split("/ *(, *)+/", $row['coupons']));
        if (!empty($coupons)) $dto['coupons'] = $coupons;
        
        return $dto;
    }
}

class Fs2psOrderLineExtractor extends Fs2psOrderDependentExtractor
{
    
    protected $productMatcher;
    protected $combiMatcher;
    protected $extra_metas;
    
    public function __construct($task, $name)
    {
        parent::__construct($task, $name);
        $this->productMatcher = Fs2psMatcherFactory::get($task, 'products');
        $this->combiMatcher = Fs2psMatcherFactory::get($task, 'combinations');
    }

    protected function reloadCfg() {
        parent::reloadCfg();
        $cfg = $this->task->cfg;
        $this->extra_metas = $cfg->get('ORDER_LINES_EXTRA_METAS', '');
    }
    
    protected function buildSql()
    {
        $hpos = $this->hpos_enabled;

        $select = [];
        if (!empty($this->extra_metas)) {
            foreach (explode(',', $this->extra_metas) as $meta) {
                $alias_meta = Fs2psTools::str2DbAlias($meta);
                array_push($select, "(select max(meta_value) from @DB_woocommerce_order_itemmeta m where m.order_item_id=oi.order_item_id and m.meta_key='".$meta."') as ".$alias_meta);
            }
        }

        // distinct m.meta_key='_product_id' con valores repetidos para el mismo order_item_id en un cliente dela?!!
        return '
			SELECT

				o.ID as id_order,
				null as id_order_invoice,
                oi.order_item_id as order_item_id,
                (select distinct meta_value from @DB_woocommerce_order_itemmeta m where m.order_item_id=oi.order_item_id and m.meta_key=\'_product_id\') as product_id,
                (
                    -- Usamos max para evitar Subquery returns more than 1 row. A veces aparecen repetiones aunque con el mismo valor.
                    select max(pm.meta_value) from @DB_woocommerce_order_itemmeta oim
                    inner join @DB_postmeta pm on pm.post_id=oim.meta_value and pm.meta_key=\'_sku\'
                    where oim.order_item_id=oi.order_item_id  and oim.meta_key=\'_product_id\'
                ) as product_reference,
                (select meta_value from @DB_woocommerce_order_itemmeta m where m.order_item_id=oi.order_item_id and m.meta_key=\'_variation_id\') as combi_id,
                (
                    select max(pm.meta_value) from @DB_woocommerce_order_itemmeta oim
                    inner join @DB_postmeta pm on pm.post_id=oim.meta_value and pm.meta_key=\'_sku\'
                    where oim.order_item_id=oi.order_item_id  and oim.meta_key=\'_variation_id\'
                ) as combi_reference,
				oi.order_item_name as product_name,
				(select max(meta_value) from @DB_woocommerce_order_itemmeta m where m.order_item_id=oi.order_item_id and m.meta_key=\'_qty\') as quantity,
				(select sum(distinct tax_rate) from @DB_woocommerce_tax_rates where tax_rate_class=oim_tax_class.meta_value) as rate,
                (select max(meta_value) from @DB_woocommerce_order_itemmeta m where m.order_item_id=oi.order_item_id and m.meta_key=\'_line_subtotal\') as line_subtotal,
                (select max(meta_value) from @DB_woocommerce_order_itemmeta m where m.order_item_id=oi.order_item_id and m.meta_key=\'_line_subtotal_tax\') as line_subtotal_tax,
                (select max(meta_value) from @DB_woocommerce_order_itemmeta m where m.order_item_id=oi.order_item_id and m.meta_key=\'_line_total\') as line_total,
                (select max(meta_value) from @DB_woocommerce_order_itemmeta m where m.order_item_id=oi.order_item_id and m.meta_key=\'_line_tax\') as line_tax
                '.(!empty($select) ? ','.implode(',', $select) : '').'

			FROM

                '.($hpos? '@DB_wc_orders' : '@DB_posts').' o
                '.($hpos?
                    'left join @DB_wc_order_addresses a on a.order_id=o.id and a.address_type=\'billing\'' : 
                    'left join @DB_postmeta om on om.post_id=o.ID and om.meta_key=\'_billing_email\''
                ).'
                inner join @DB_woocommerce_order_items oi on oi.order_id=o.ID and oi.order_item_type in (\'line_item\',\'fee\')
			    inner join @DB_woocommerce_order_itemmeta oim_tax_class on oim_tax_class.order_item_id=oi.order_item_id and oim_tax_class.meta_key=\'_tax_class\'

			WHERE
				'.$this->getAfterDateWhereCondition().'
			
            ORDER BY '.($hpos? 'o.date_updated_gmt' : 'o.post_modified').', o.ID, oi.order_item_id
		';
    }
    
    protected function row2dto($row)
    {
        if (intval($row['combi_id'])) {
            $m = $this->combiMatcher;
            $dto_id_str = $m->dtoIdStrFromRowId($row['combi_id']);
            if (empty($dto_id_str)) $dto_id_str = $row['combi_reference']; // Puede que queden por descargar pedidos anteriores al cambio de matcher
            $dto_id = $m->strToDtoId($dto_id_str);
        } else {
            $m = $this->productMatcher;
            $dto_id = $m->dtoIdStrFromRowId($row['product_id']);
            if (empty($dto_id)) $dto_id = $row['product_reference']; // Puede que queden por descargar pedidos anteriores al cambio de matcher
        }
        
        if ($dto_id===null) $dto_id = '';
        $is_array = is_array($dto_id);
        if ($is_array && sizeof($dto_id)!=3) {
            $dto_id = empty($row['combi_reference'])? $row['product_reference'] : $row['combi_reference']; // Sólo combis pueden ser arrays y deben ser de 3 elemns.
            $is_array = false;
        }
        
        /*
         _product_id	4516
         _variation_id
         _qty	3
         tallas	S/M
         _line_subtotal	89.1322			Base de linea antes del descuento
         _line_subtotal_tax	18.7178		IVA de linea antes del descuento
         _line_total	80.2231				Base de linea después del descuento
         _line_tax	16.8469				IVA de linea después del descuento
         */
        
        // A veces no se indica cantidad. En esos casos consideramos cantidad 1 y totales de base e impuestos como precios unitarios
        $qty = $row['quantity']? floatval($row['quantity']) : 1;

        # subtotal: antes de aplicar descuento (orig)
        # total: con descuento aplicado
        $line_base_orig = floatval(empty($row['line_subtotal'])? $row['line_total'] : $row['line_subtotal']);
        $line_base = floatval($row['line_total']);
        $line_tax_orig = floatval(empty($row['line_subtotal_tax'])? $row['line_tax'] : $row['line_subtotal_tax']);
        $line_tax = floatval($row['line_tax']);
        $line_price_orig = round(round($line_base_orig, $this->price_num_decimals) + $line_tax_orig, $this->price_num_decimals);
        $line_price = round(round($line_base, $this->price_num_decimals) + $line_tax, $this->price_num_decimals);
        
        // Ignoramos descuentos en totales si se consideran en las lineas o si salen negativos
        if($this->orders_discount_preference != 'lines' || $line_base_orig<$line_base || $line_price_orig<$line_price){
            $line_base = $line_base_orig;
            $line_tax = $line_tax_orig;
            $line_price = $line_price_orig;
        }
        
        $tax = round(floatval($row['rate']), 2);        
        $line_base_disc = $line_base_orig - $line_base;
        $line_price_disc = $line_price_orig - $line_price;
        
        // Incorporado a partir de 2.5.2, 2.7.1, 2.6.2
        $unit_base = $qty? $line_base/$qty : 0.0;
        $unit_base_disc = $qty? $line_base_disc/$qty : 0.0;
        $unit_base_orig = $qty? $line_base_orig/$qty : 0.0;
        $unit_tax = $qty? $line_tax/$qty : 0.0;
        $unit_price_orig = $qty? $line_price_orig/$qty : 0.0;
        $unit_price = $qty? $line_price/$qty : 0.0;
        $unit_price_disc = $qty? $line_price_disc/$qty : 0.0;
        
        $discount_perc = $line_price? $line_price_disc/$line_price : 0.0;
        
        //$row['id_product']
        //$row['id_combi']

        $dto = [
            'order' => intval($row['id_order']),
            // invoice => intval($row['id_order_invoice']),
            'ref' => $is_array? $dto_id[0] : $dto_id,
            'name' => $row['product_name'],
            'size' => $is_array? $dto_id[1] : '',
            'color' => $is_array? $dto_id[2] : '',
            
            'quantity' => $qty,
            'tax' => $tax,
            
            'unit_base_orig' => $unit_base_orig,
            'unit_base_disc' => $unit_base_disc,
            'discount_perc' => $discount_perc,
            // unit_base => unit_base_orig - unit_base_disc,
            // line_base = unit_base * quantity
            'unit_tax_imp' => $unit_tax, // unit_tax
            
            // Se usaban antes de 2.5.2, 2.7.1, 2.6.2 ¿Harán falta después? Los conservamos por compat con 2.X
            'price' => $unit_price_orig,
            'discount' => $unit_price_disc,
            'total' => $line_price, // line_price = unit_price * quantity
            'tax_imp' => $line_tax, // line_tax = unit_tax * quantity
        ];
        
        if (!empty($this->extra_metas)) {
            $extra_metas = [];
            foreach (explode(',', $this->extra_metas) as $meta) {
                $alias = Fs2psTools::str2DbAlias($meta);
                if (isset($row[$alias])) $extra_metas[$meta] = maybe_unserialize($row[$alias]);
            }
            $dto['extra_metas'] = $extra_metas;
        }

        return $dto;
    }
}

class Fs2psCategoryExtractor extends Fs2psMatchedExtractor
{
    protected function row2dto($row)
    {
        $dto = parent::row2dto($row);
        $dto['name'] = $row['name'];
        $dto['parent'] = null;
        return $dto;
    }
    
    public function getLevelFromDownloadCfg($download) {
        $matches = array();
        preg_match('/^level\_([0-9]+)$/i', strval($download), $matches);
        return $matches? intval($matches[1]) : null;
    }
    
    protected function buildSqlByLevel($level)
    {
        $ml_joins = '';
        if ($this->multilang_plugin=='wpml') {
            $ml_joins =  'inner join `@DB_icl_translations` tra ON tra.element_id=t.term_id AND tra.element_type=CONCAT(\'tax_\', c'.$level.'.taxonomy) and tra.language_code=\''.$this->default_lang.'\'';
        }
        
        return '
        	select distinct c'.$level.'.term_id as id, t.name, c'.$level.'.parent as id_parent
        	from @DB_term_taxonomy c0
        	left join @DB_term_taxonomy c1 on c1.parent=c0.term_id
            left join @DB_term_taxonomy c2 on c2.parent=c1.term_id
            left join @DB_term_taxonomy c3 on c3.parent=c2.term_id
            left join @DB_term_taxonomy c4 on c4.parent=c3.term_id
            left join @DB_terms t on t.term_id=c'.$level.'.term_id
            '.$ml_joins.'
        	where c0.taxonomy=\'product_cat\' and c0.parent=0 and c'.$level.'.term_id is not null
            order by id_parent, id
        ';
    }
}

class Fs2psSectionExtractor extends Fs2psCategoryExtractor
{
    protected function buildSql()
    {
        $cfg = $this->task->cfg;
        $level = $this->getLevelFromDownloadCfg($cfg->get('DOWNLOAD_SECTIONS', true));
        if ($level!==null) return $this->buildSqlByLevel($level);
        
        $ml_joins = '';
        if ($this->multilang_plugin=='wpml') {
            $ml_joins =  'inner join `@DB_icl_translations` tra ON tra.element_id=t.term_id AND tra.element_type=CONCAT(\'tax_\', c.taxonomy) and tra.language_code=\''.$this->default_lang.'\'';
        }
            
        return '
            select distinct pc.term_id as id, t.name, null as id_parent
            from @DB_term_taxonomy c
            left join @DB_term_taxonomy cc on cc.parent=c.term_id
            inner join @DB_term_taxonomy pc on pc.term_id=c.parent -- and pc.is_root_category=0
            inner join @DB_terms t on t.term_id=pc.term_id
            '.$ml_joins.'
            -- inner join `@DB_term_relationships` tra on tra.object_id=t.term_id and tra.term_taxonomy_id=12
            where c.taxonomy=\'product_cat\' and cc.term_id is null -- and pc.term_id is not null -- inner join
            ORDER BY id_parent, id
        ';
    }
}

class Fs2psFamilyExtractor extends Fs2psCategoryExtractor
{
    protected $sectionMatcher;
    
    public function __construct($task, $name)
    {
        parent::__construct($task, $name);
        $this->sectionMatcher = Fs2psMatcherFactory::get($task, $name);
    }
    
    protected function buildSql()
    {
        $cfg = $this->task->cfg;
        $level = $this->getLevelFromDownloadCfg($cfg->get('DOWNLOAD_FAMILIES', true));
        if ($level) return $this->buildSqlByLevel($level);
        
        $ml_joins = '';
        if ($this->multilang_plugin=='wpml') {
            $ml_joins =  'inner join `@DB_icl_translations` tra ON tra.element_id=t.term_id AND tra.element_type=CONCAT(\'tax_\', c.taxonomy) and tra.language_code=\''.$this->default_lang.'\'';
        }
        
        return '
            select distinct c.term_id as id, t.name, pc.term_id as id_parent
            from @DB_term_taxonomy c
            inner join @DB_terms t on t.term_id=c.term_id
            left join @DB_term_taxonomy cc on cc.parent=c.term_id
            left join @DB_term_taxonomy pc on pc.term_id=c.parent -- and pc.is_root_category=0
            '.$ml_joins.'
            -- inner join `@DB_term_relationships` tra on tra.object_id=t.term_id and tra.term_taxonomy_id=12
            where c.taxonomy=\'product_cat\' and cc.term_id is null
            ORDER BY id_parent, id
        ';
    }
    
    protected function row2dto($row)
    {
        $dto = parent::row2dto($row);
        $dto['parent'] = empty($row['id_parent'])? '' : $this->sectionMatcher->dtoIdStrFromRowId($row['id_parent']);
        return $dto;
    }
}


class Fs2psSimpleTaxonomyExtractor extends Fs2psMatchedExtractor
{
    protected function buildSql()
    {
        $ml_joins = '';
        if ($this->multilang_plugin=='wpml') {
            $ml_joins =  'inner join `@DB_icl_translations` tra ON tra.element_id=t.term_id AND tra.element_type=\'tax_'.$this->matcher->taxonomy.'\' and tra.language_code=\''.$this->default_lang.'\'';
        }
        
        return '
            select distinct c.term_id as id, t.name
            from @DB_term_taxonomy c
            inner join @DB_terms t on t.term_id=c.term_id
            '.$ml_joins.'
            -- inner join `@DB_term_relationships` tra on tra.object_id=t.term_id and tra.term_taxonomy_id=12
            where c.taxonomy=\''.$this->matcher->taxonomy.'\'
            ORDER BY id
        ';
    }
    
    protected function row2dto($row)
    {
        $dto = parent::row2dto($row);
        $dto['name'] = $row['name'];
        return $dto;
    }
}

class Fs2psManufacturerExtractor extends Fs2psSimpleTaxonomyExtractor { }

class Fs2psSupplierExtractor extends Fs2psSimpleTaxonomyExtractor { }

class Fs2psAttributeGroupExtractor extends Fs2psMatchedExtractor
{
    protected static function matchSql($value) {
        return '( select \''.$value.'\' as id from dual )';
        //return '( select FIRST(\''.$value.'\') as id from @DB_attribute_group ag where id_attribute_group in ('.$value.') )';
    }
    
    protected function buildSql()
    {
        $forced_matches = $this->matcher->forced_maches;
        if (empty($forced_matches)) {
            throw new Fs2psException("No se indicaron valores IMATCH_".strtoupper($this->name));
        }
        
        $filtered_keys = preg_grep("/^(SIZES)|(COLOURS)$/", array_keys($forced_matches));
        $filtered_values = preg_grep("/^([0-9]+,)*[0-9]+$/", array_values($forced_matches));
        if (sizeof($filtered_keys)<sizeof($forced_matches) || sizeof($filtered_values)<sizeof($forced_matches)) {
            throw new Fs2psException("Se indicaron elementos inválidos en IMATCH_".strtoupper($this->name));
        }
        
        return implode(' UNION ', array_map('self::matchSql', $filtered_values));
    }
}

/*
 class Fs2psAttributeExtractor extends Fs2psExtractor
 {
 protected $selection;
 protected $rMatcher;
 protected $rNextId;
 
 protected function reloadCfg() {
 parent::reloadCfg();
 
 $selection_cfg_name = strtoupper($this->name).'_REMOTE_SELECTION';
 $selection = $this->task->cfg->get($selection_cfg_name);
 if (!empty($selection) && !is_array($selection)) {
 $selection = array($selection);
 }
 if (empty($selection)) {
 throw new Fs2psServerFatalException('No se indicó '.$selection_cfg_name);
 }
 $nselection = sizeof($selection);
 for ($i = 0; $i<$nselection; $i++) {
 $selection[$i] = '\'attribute_pa_'.Fs2psTools::dbEscape($selection[$i]).'\'';
 }
 $this->selection = $selection;
 }
 
 public static function createRMatcher($task, $name) {
 return new Fs2psDto2RowMatcher('r'.$name, 'product_attribute', 'id_product_attribute', array('ref'), true);
 }
 
 public function __construct($task, $name)
 {
 parent::__construct($task, $name);
 
 $this->rMatcher = self::createRMatcher($task, $name);
 $this->rNextId = Fs2psTools::dbValue('
 select max(cast(dto_id as unsigned))
 from @DB_fs2ps_match
 where `table`=\'product_attribute\' and entity=\'r'.$name.'\'
 ') + 1;
 }
 
 public function getSelection() { return $this->selection; }
 public function getRMatcher() { return $this->rMatcher; }
 
 protected function buildSql()
 {
 return '
 select distinct
 -- REPLACE(GROUP_CONCAT(pacv.meta_key order by pacv.meta_key SEPARATOR \'_\'), \'attribute_pa_\' ,\'\'),
 GROUP_CONCAT(pacv.meta_value order by pacv.meta_key) as id, -- XXX cfillol: Como obtenemos id del attributo??
 GROUP_CONCAT(pacv.meta_value order by pacv.meta_key SEPARATOR \'x\') as name
 from @DB_posts p
 inner join @DB_posts pac on pac.post_parent=p.ID and pac.post_type=\'product_variation\'
 inner join @DB_postmeta pacv on pacv.post_id=pac.ID and meta_key in ('.join($this->selection, ',').')
 where p.post_type=\'product\' and p.post_status=\'publish\'
 group by pac.ID
 ';
 }
 
 protected function row2dto($row)
 {
 $rMatcher = $this->rMatcher;
 $ref = $rMatcher->_rowIdFromDtoId($row['id']);
 if (empty($ref)) {
 $ref = $this->rNextId;
 $this->rNextId++;
 }
 $rMatcher->updateMatch($row['id'], $ref);
 
 $dto = array( 'ref' => $ref, 'name' => $row['name'] );
 
 / *
 if (strlen($row['color'])>0 && $row['color'][0]=='#') {
 $dto['colour'] = substr(explode(',', $row['color'])[0], 1);
 }
 * /
 
 return $dto;
 
 }
 }
 */

class Fs2psAttributeExtractor extends Fs2psMatchedExtractor
{
    
    protected function buildSql()
    {
        $group_row_ids = $this->task->getExtractor('attribute_groups')->matcher->rowIdFromDtoId(strtoupper($this->name));
        $group_row_ids_str = empty($group_row_ids)? 0 : (is_array($group_row_ids)? implode(',', $group_row_ids) : $group_row_ids);
        
        $ml_joins = '';
        if ($this->multilang_plugin=='wpml') {
            $ml_joins = 'inner join `@DB_icl_translations` tra ON tra.element_id=t.term_id AND tra.element_type=CONCAT(\'tax_\', tt.taxonomy) and tra.language_code=\''.$this->default_lang.'\'';
        }
        
        return '
            select t.term_id as id, t.name
            from `@DB_woocommerce_attribute_taxonomies` wat
            inner join `@DB_term_taxonomy` tt on CONVERT(tt.taxonomy  USING utf8mb4) = CONVERT(concat(\'pa_\', wat.attribute_name) USING utf8mb4)
            inner join `@DB_terms` t on t.term_id=tt.term_id
            '.$ml_joins.'
            -- inner join `@DB_term_relationships` tra on tra.object_id=t.term_id and tra.term_taxonomy_id=12
            where wat.attribute_id in ('.$group_row_ids_str.')
		';
    }
    
    protected function row2dto($row)
    {
        try {
            $dto = parent::row2dto($row);
        } catch (Fs2psCannotGetDtoIFromRowId $e) {
            // ¿Descartamos la generación de este atributo?
            if (empty($this->matcher->deduceDtoIdStrFromName($row['name']))) return null;
            else throw $e;
        }
        
        $dto['name'] = $row['name'];
        /*
         if (strlen($row['color'])>0 && $row['color'][0]=='#') {
         $dto['colour'] = substr(explode(',', $row['color'])[0], 1);
         }
         */
        
        return $dto;
    }
    
}

/* TODO en Woo
 class Fs2psManufacturerExtractor extends Fs2psMatchedExtractor
 {
 protected function buildSql()
 {
 return 'select id_manufacturer as id, name FROM @DB_manufacturer';
 }
 
 protected function row2dto($row)
 {
 $dto = parent::row2dto($row);
 $dto['name'] = $row['name'];
 return $dto;
 }
 }
 */

class Fs2psProductExtractor extends Fs2psMatchedExtractor
{
    protected $familyMatcher;
    protected $manufacturerMatcher;
    
    public function __construct($task, $name)
    {
        $this->ean_metakey = $task->cfg->get('EAN_METAKEY', 'false');
        $this->familyMatcher = $task->getExtractor('families')? $task->getExtractor('families')->matcher : null;
        $this->manufacturerMatcher = $task->getExtractor('manufacturers')? $task->getExtractor('manufacturers')->matcher : null;
        parent::__construct($task, $name);
    }
    
    protected function buildSql()
    {
        $ml_joins = '';
        if ($this->multilang_plugin=='wpml') {
            $ml_joins = 'inner join `@DB_icl_translations` t ON t.element_id=p.ID AND t.element_type=CONCAT(\'post_\', p.post_type) and t.language_code=\''.$this->default_lang.'\'';
        }

        $ean_metakey_query = "";
        if ($this->ean_metakey != false) {
            $ean_metakey_query = "(select meta_value from @DB_postmeta  where post_id=IFNULL(pa.ID,p.ID) and meta_key='".$this->ean_metakey."')";
        }
        
        return '
			SELECT
			    p.ID as id,
			    p.post_date,
			    p.post_modified,
			    p.post_title,
				p.post_status,
			    p.post_content as longdescrip,
			    p.post_excerpt as descrip,
			    (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_regular_price\') as price,
				(select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_sale_price\') as sale_price,
			    (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_sku\') as sku,
			    (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_manage_stock\') as manage_stock,
			    (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_stock\') as stock,
			    (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_tax_status\') as tax_status,
			    (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_tax_class\') as tax_class,
			    -- (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_thumbnail_id\') as thumbnail_id,
				-- (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_product_image_gallery\') as product_image_gallery,
			    -- (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_product_attributes\') as product_attributes,
                '.$ean_metakey_query.' as ean,

			    -- weight, width, length, height
                (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_weight\') as weight,

				-- TODO: categoria
                (
                    select min(c.term_id)
                    from @DB_term_relationships tr
                    inner join @DB_term_taxonomy c on c.term_taxonomy_id=tr.term_taxonomy_id and c.taxonomy=\'product_cat\'
                    inner join @DB_terms t on t.term_id=c.term_id
                    left join @DB_term_taxonomy cc on cc.parent=c.term_id
                    left join @DB_term_taxonomy pc on pc.term_id=c.parent -- and pc.is_root_category=0
                    where tr.object_id=p.ID and cc.term_id is null
                ) as id_family

                '.($this->manufacturerMatcher?'
                ,(
                    select min(c.term_id)
                    from @DB_term_relationships tr
                    inner join @DB_term_taxonomy c on c.term_taxonomy_id=tr.term_taxonomy_id and c.taxonomy=\''.$this->manufacturerMatcher->taxonomy.'\'
                    inner join @DB_terms t on t.term_id=c.term_id
                    where tr.object_id=p.ID
                ) as id_manufacturer
                ':'').'
			FROM
			    @DB_posts p
                -- left join @DB_postmeta psku on psku.post_id=p.ID and psku.meta_key=\'_sku\'
                '.$ml_joins.'
                -- inner join `@DB_term_relationships` tra on tra.object_id=p.ID and tra.term_taxonomy_id=11
			WHERE p.post_type=\'product\' and p.post_status<>\'draft\' -- psku.meta_value>\'\' and p.ID=134
			ORDER BY p.ID
		';
    }
    
    protected function row2dto($row)
    {
        $dto = parent::row2dto($row);
        if(empty($dto)) return $dto;
        
        $dto = array_merge($dto, array(
            'name' => $row['post_title'],
            'created' => $row['post_date'],
            'updated' => $row['post_modified'],
            'enabled' => $row['post_status']=='publish',
            'stock' => $row['manage_stock']=='yes'? floatval($row['stock']) : 0,
            'descrip' => $row['descrip'],
            'pref' => $row['sku'],
        ));
        
        if (!empty($row['longdescrip'])) {
            $dto['longdescrip'] = apply_filters('the_content', $row['longdescrip']);
        }
        
        if ($row['tax_status']=='taxable') {
            $dto['tax_class'] = $row['tax_class'];
        }
        
        $cfg = $this->task->cfg;
        if ($cfg->get('PRICES_INCLUDE_TAX')) {
            $dto['price'] = floatval($row['price']);
            if (!empty($row['sale_price'])) $dto['sale_price'] = floatval($row['sale_price']);
        } else {
            $dto['price_base'] = floatval($row['price']);
            if (!empty($row['sale_price'])) $dto['sale_price_base'] = floatval($row['sale_price']);
        }
        
        if ($this->familyMatcher) {
            $dto['family'] = empty($row['id_family'])? '' : $this->familyMatcher->dtoIdStrFromRowId($row['id_family']);
        }
        if ($this->manufacturerMatcher) {
            $dto['manufacturer'] = empty($row['id_manufacturer'])? '' : $this->manufacturerMatcher->dtoIdStrFromRowId($row['id_manufacturer']);
        }
        
        if (!empty($row['weight'])) $dto['weight'] = floatval($row['weight']);

        if (!empty($row['ean'])) $dto['ean'] = $row['ean'];
        
        return $dto;
    }
    
}

class Fs2psSizeColourCombinationExtractor extends Fs2psMatchedExtractor
{
    
    protected function buildSql()
    {
        /*
         return '
         SELECT
         p.ID as id,
         max(pp.ID) as parent,
         (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_regular_price\') as price,
         (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_sale_price\') as sale_price,
         (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_sku\') as sku,
         (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_manage_stock\') as manage_stock,
         (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_stock\') as stock,
         (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_tax_status\') as tax_status,
         (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_tax_class\') as tax_class,
         (select meta_value from @DB_postmeta where post_id=pp.ID and meta_key=\'_tax_class\') as parent_tax_class
         -- (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_thumbnail_id\') as thumbnail_id,
         -- (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_product_image_gallery\') as product_image_gallery,
         -- (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_product_attributes\') as product_attributes,
         
         -- weight, width, length, height
         (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_weight\') as weight
         
         FROM
         `@DB_posts` p
         inner join `@DB_posts` pp on pp.ID=p.post_parent
         
         inner join `@DB_woocommerce_attribute_taxonomies` wats on wats.attribute_id in ('.$this->matcher->sizeAttributeGroupIdsInSql.')
         left join `@DB_postmeta` pacsv on pacsv.post_id=p.ID and convert(pacsv.meta_key USING utf8mb4) =convert(concat(\'attribute_pa_\', wats.attribute_name) USING utf8mb4)
         left join `@DB_term_taxonomy` tts on convert(tts.taxonomy USING utf8mb4)  = convert(concat(\'pa_\', wats.attribute_name) USING utf8mb4)
         left join `@DB_terms` ts on ts.term_id=tts.term_id and ts.slug=pacsv.meta_value
         
         inner join `@DB_woocommerce_attribute_taxonomies` watc on watc.attribute_id in ('.$this->matcher->colourAttributeGroupIdsInSql.')
         left join `@DB_postmeta` paccv on paccv.post_id=p.ID and paccv.meta_key=concat(\'attribute_pa_\', watc.attribute_name)
         left join `@DB_term_taxonomy` ttc on ttc.taxonomy = concat(\'pa_\', watc.attribute_name)
         left join `@DB_terms` tc on tc.term_id=ttc.term_id and tc.slug=paccv.meta_value
         WHERE
         p.post_type=\'product_variation\' and pp.post_status=\'publish\'
         and (ts.term_id is not null or tc.term_id is not null)
         GROUP BY p.ID
         ORDER BY pp.ID, p.ID
         ';
         */
        
        $ml_joins = '';
        if ($this->multilang_plugin=='wpml') {
            $ml_joins = 'inner join `@DB_icl_translations` t ON t.element_id=p.ID AND t.element_type=CONCAT(\'post_\', p.post_type) and t.language_code=\''.$this->default_lang.'\'';
        }
        
        return '
			SELECT
			    p.ID as id,
                max(pp.ID) as parent,
			    (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_regular_price\' limit 1) as price,
				(select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_sale_price\' limit 1) as sale_price,
			    (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_sku\' limit 1) as sku,
			    (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_manage_stock\' limit 1) as manage_stock,
			    (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_stock\' limit 1) as stock,
			    (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_tax_status\' limit 1) as tax_status,
			    (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_tax_class\' limit 1) as tax_class,
			    (select meta_value from @DB_postmeta where post_id=pp.ID and meta_key=\'_tax_class\' limit 1) as parent_tax_class,
			    -- (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_thumbnail_id\') as thumbnail_id,
			    -- (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_product_image_gallery\') as product_image_gallery,
			    -- (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_product_attributes\') as product_attributes,

			    -- weight, width, length, height
                (select meta_value from @DB_postmeta where post_id=p.ID and meta_key=\'_weight\') as weight

			FROM
			    `@DB_posts` p
			    inner join `@DB_posts` pp on pp.ID=p.post_parent

                -- Hacer join con p o con pp (post_parent)? 
                '.$ml_joins.'
                -- inner join `@DB_term_relationships` tra on tra.object_id=p.ID and tra.term_taxonomy_id=11               
                    
			WHERE
                p.post_type=\'product_variation\' and pp.post_type=\'product\' and pp.post_status<>\'draft\'
                -- and (ts.term_id is not null) -- or tc.term_id is not null
			GROUP BY p.ID
			ORDER BY pp.ID, p.ID
		';
        
    }
    
    protected function row2dto($row)
    {
        $dto = parent::row2dto($row);
        //if(empty($dto)) return $dto;
        
        $dto = array_merge($dto, array(
            'pref' => $row['sku'],
        ));
        
        if ($row['tax_status']=='taxable') {
            $dto['tax_class'] = $row['tax_class']=='parent'? $row['parent_tax_class'] : $row['tax_class'];
        }
        
        $cfg = $this->task->cfg;
        if ($cfg->get('PRICES_INCLUDE_TAX')) {
            $dto['price'] = floatval($row['price']);
            if (!empty($row['sale_price'])) $dto['sale_price'] = floatval($row['sale_price']);
        } else {
            $dto['price_base'] = floatval($row['price']);
            if (!empty($row['sale_price'])) $dto['sale_price_base'] = floatval($row['sale_price']);
        }
        
        if ($row['manage_stock']=='yes') {
            $dto['stock'] = floatval($row['stock']);
        }
        
        if (!empty($row['weight'])) $dto['weight'] = floatval($row['weight']);
        
        return $dto;
    }
}

class Fs2psProductImageExtractor extends Fs2psExtractor {

    protected $after;
    public function __construct($task, $name)
    {
        parent::__construct($task, $name);
        $this->task = $task;
        $this->productMatcher = Fs2psMatcherFactory::get($task, 'products');
        //$this->combiMatcher = Fs2psMatcherFactory::get($task, 'combinations');
    }

    protected function reloadCfg() {
        parent::reloadCfg();

        if(!empty($this->task->cmd['after'])) {
            $this->after_str = Fs2psTools::date2db(Fs2psTools::dto2date($this->task->cmd['after']));
        }

        $cfg = $this->task->cfg;
        $download_images = $cfg->get('DOWNLOAD_PRODUCTS_IMAGES', '');
        $this->cover = array_search('onlycover', $download_images) !== false;
    }

    protected function buildSql()
    {

        $where_updated = '';
        if(!empty($this->task->cmd['after'])) {
            $this->after_str =  Fs2psTools::date2db(Fs2psTools::dto2date($this->task->cmd['after']));
            $where_updated = 'and i.post_modified>\''.$this->after_str.'\'';
        }
        /*
        $and_position = 'position>0';
        if(!empty($this->cover)){
            $and_position = 'position=1';
        }
        */
        if(!empty($this->cover)){
            //De momento usamos dos consultas separadas dependiendo de si queremos descargar las imagenes o no.
            return '
                select
                    1 as position,
                    p.ID as id_product,
                    i.ID as id_image,
                    i.post_modified as updated
                from @DB_posts p
                inner join @DB_postmeta cpm on cpm.post_id=p.ID and cpm.meta_key="_thumbnail_id"
                left join @DB_posts i on i.ID=cpm.meta_value and (cpm.meta_key="_thumbnail_id" or cpm.meta_key="_product_image_gallery")
                where p.post_type = "product" '.$where_updated.'
                order by i.post_modified, p.ID
            ';
        }

        return  '
        select * 
        from (
            select 
                FIND_IN_SET(i.ID, CONCAT(cpm.meta_value, ",", ipm.meta_value)) as position, 
                p.ID as id_product, 
                i.ID as id_image,
                p.updated
            from (
                select p.ID, max(i.post_modified) as updated
                from @DB_posts p
                inner join @DB_posts i on i.post_parent=p.ID and i.post_type = "attachment"
                inner join @DB_postmeta cpm on cpm.post_id = p.ID and cpm.meta_key="_thumbnail_id"
                inner join @DB_postmeta ipm on ipm.post_id = p.ID and ipm.meta_key="_product_image_gallery"
                where 
                    p.post_type = "product" '.$where_updated.' and
                    FIND_IN_SET(i.ID, CONCAT(cpm.meta_value, ",", ipm.meta_value))>0
                group by p.ID
            ) p
            inner join @DB_posts i on i.post_parent=p.ID and i.post_type = "attachment"
            inner join @DB_postmeta cpm on cpm.post_id = p.ID and cpm.meta_key="_thumbnail_id"
            inner join @DB_postmeta ipm on ipm.post_id = p.ID and ipm.meta_key="_product_image_gallery"
        ) t
        where position>0
        order by updated,id_product,position
        ';
    }
    protected function row2dto($row)
    {
        $dto = array();
        $dto['id_product'] = $row['id_product'];
        $dto['position'] = $row['position'];
        $dto['product'] = $this->productMatcher->dtoIdFromRowId(intval($row['id_product'])); // safeDtoIdStrFromRowId

        // get_post_mime_type devuelve images/jpeg, tratamos la cadena para aislar el tipo.
        $dto['type'] = (explode('/',get_post_mime_type($row['id_image'])))[1]; 
        // wp_get_attachment_image_src devuelve la ruta donde se ha guardado esa imagen en local
        $dto['img_url'] = (wp_get_attachment_image_src($row['id_image'], 'full'))[0];
        
        $path = substr($dto['img_url'], strpos($dto['img_url'], 'wp-content'));
        $path = (explode('?', $path))[0]; //Quitamos los parametros de la url
        //ABSPATH es la ruta de instalación de nuestro Wordpress
        $dto['data'] = base64_encode(file_get_contents(ABSPATH.$path));
    
    return $dto;
    }
}


