<?php
/**
* LICENCIA
*
* Este programa se propociona "tal cual", sin garantía de ningún tipo más allá del soporte
* pactado a la hora de adquirir el programa.
*
* En ningún caso los autores o titulares del copyright serán responsables de ninguna
* reclamación, daños u otras responsabilidades, ya sea en un litigio, agravio o de otro
* modo, que surja de o en conexión con el programa o el uso u otro tipo de acciones
* realizadas con el programa.
*
* Este programa no puede modificarse ni distribuirse sin el consentimiento expreso del autor.
*
*    @author    Carlos Fillol Sendra <festeweb@festeweb.com>
*    @copyright 2014 Fes-te web! - www.festeweb.com
*    @license   http://www.festeweb.com/static/licenses/fs2ps_1.1.0.txt
*/

include_once(dirname(__FILE__).'/Fs2psObjectModels.php');
include_once(dirname(__FILE__).'/Fs2psMatcherFactory.php');

class Fs2psDto2RowMatcher
{
    public $entity;
	public $table;
	public $dto_id_fields;
	public $row_id_field;
	public $persist;
	public $forced_maches;
	public $forced_maches_reverse;
	public $direct_match;
	public $genidinc;
	public $cache = FALSE;
	

	public function __construct($entity, $table, $row_id_field=null, $dto_id_fields=null, $persist = true, $cache=false)
	{
		$this->entity = $entity;
		$this->table = empty($table)? '' : $table;
		$this->row_id_field = $row_id_field? $row_id_field : (empty($table)? null : Fs2psObjectModel::idForTable($table));
		$this->dto_id_fields = $dto_id_fields? $dto_id_fields : array('ref');
		$this->persist = $persist;
		$this->cache = $cache;
	}
	
	public function reloadCfg($cfg) {
	    $updpart = strtoupper($this->entity);
	    $this->forced_maches = $cfg->get('MATCH_'.$updpart, array());
	    $this->forced_maches_reverse = array_flip($this->forced_maches);
	    $this->direct_match = $cfg->get('DIRECT_MATCH_'.$updpart, false);
	    $this->genidinc = $cfg->get($updpart.'_GENIDINC', 0);
	}

	
	public function dtoIdToStr($dto_id)
	{
	    if (is_array($dto_id))
	    {
	        $dto_id_array = array();
	        foreach ($dto_id as $id_part)
	        {
	            $id_part = empty($id_part) && $id_part!=='0' ? '' : $id_part; // empty de string '0' se evalúa a true!!!?? 
	            
	            // Escape id_part separator in each id_part: '_' -> '#_'
	            $id_part = str_replace('#', '##', $id_part);
	            $id_part = str_replace('_', '#_', $id_part);
	            
	            $dto_id_array[] = $id_part;
	        }
	        return implode('_', $dto_id_array);
	    }
	    return (string)$dto_id;
	}
	
	public function strToDtoId($str)
	{
	    if (empty($str) && $str!=='0') return null; // empty de string '0' se evalúa a true!!!??
	    
	    $str = $str.'_';
	    $dto_id_array = array();
	    
	    $matches = null;
	    preg_match('/^(?:((?:(?:#_)|(?:##)|[^_])*)_)/', $str, $matches);
	    while (!empty($matches))
	    {
	        $id_part = $matches[1];
	        
	        // Go to next match
	        $str = substr($str, strlen($id_part) + 1);
	        preg_match('/^(?:((?:(?:#_)|(?:##)|[^_])*)_)/', $str, $matches);
	        
	        // Reverse _ and # escaping
	        $id_part = str_replace('#_', '_', $id_part);
	        $id_part = str_replace('##', '#', $id_part);
	        
	        $dto_id_array[] = $id_part;
	    }
	    
	    if (empty($dto_id_array)) return null;
	    return count($dto_id_array) > 1? $dto_id_array : $dto_id_array[0];
	}

	public function dtoIdToStrFromDto($dto)
	{
	    return $this->dtoIdToStr($this->dtoId($dto));
	}
	
	public function idFromFields($dto, $fields)
	{
	    if (!$fields) return null;
	    
	    $id_as_array = array();
	    foreach ($fields as $f)
	    {
	        $value = isset($dto[$f])? $dto[$f] : null;
	        $value = empty($value) && $value!=='0' ? null : $value; // empty de string '0' se evalúa a true!!!??
	        array_push($id_as_array, $value);
	    }
	    return count($id_as_array) > 1 ? $id_as_array : $id_as_array[0];
	}
	
	public function dtoId($dto) {
	    if (isset($dto['_id'])) return $dto['_id'];
	    $id = $this->idFromFields($dto, $this->dto_id_fields);  
	    $dto['_id'] = $id;
	    return $id;
	}
	
	/**
	 * return null: no sobreescribe
	 * return '': sobreescribe a vacío
	 */
	public function referenceFromDto($dto)
	{
	    // Si pref devolvemos pref. Sino return:
	    // ref: $this->dtoIdToStrFromDto($dto)
	    // TODO: basic o pref: null
	    return isset($dto['pref'])? $dto['pref'] : $this->dtoIdToStrFromDto($dto);
	}
	
	public function rowId($row)
	{
	    if (!empty($this->row_id_field) && isset($row[$this->row_id_field])) {
	        return $row[$this->row_id_field];
	    }
	    return null;
	}
	
	
	
	protected function getMatch($dto_id, $nocache=FALSE)
	{
		$dto_id_str = Fs2psTools::dbEscape($this->dtoIdToStr($dto_id));
		if (!$nocache && $this->cache && isset($this->cache_rowid_by_dtoidstr[$dto_id_str])) return $this->cache_rowid_by_dtoidstr[$dto_id_str];
		
		$row_id = Fs2psTools::dbValue('
			select row_id
			from `@DB_fs2ps_match`
			where 
				`table`=\''.$this->table.'\' and
				(`entity`=\''.$this->entity.'\' or `entity` is null) and
				dto_id=\''.$dto_id_str.'\'
		');

		if ($row_id) {
		    if ($this->cache) $this->cache_rowid_by_dtoidstr[$dto_id_str] = $row_id;
		    return $row_id;
		} 
			
		return null;
	}
	
	protected function getReverseMatch($row_id, $nocache=FALSE)
	{
	    if (!$nocache && $this->cache && isset($this->cache_dtoid_by_rowid[$row_id])) return $this->cache_dtoid_by_rowid[$row_id];
	    
		$dto_id_str = Fs2psTools::dbValue('
			select dto_id
			from `@DB_fs2ps_match`
			where
				`table`=\''.$this->table.'\' and
				(`entity`=\''.$this->entity.'\' or `entity` is null) and
				row_id=\''.$row_id.'\'
		');
	
		if ($dto_id_str!==FALSE) {
		    if ($this->cache) $this->cache_dtoid_by_rowid[$row_id] = $dto_id_str;
			return $dto_id_str;
		}
		return null;
	}
	
	public function existsRowInDatabase($id)
	{
	    return !empty($id) && Fs2psObjectModel::existsInDatabase($id, $this->table);
	}
	
	
	public function rowIdFromDtoIdForcedMatches($dto_id)
	{
	    if ($this->direct_match) return $dto_id;
	    if (!empty($this->forced_maches))
	    {
	        $dto_id_str = $this->dtoIdToStr($dto_id);
	        if (isset($this->forced_maches[$dto_id_str]))
	            return $this->forced_maches[$dto_id_str];
	    }
	    return null;
	}
	
	public function rowIdFromDtoId($dto_id)
	{
	    $row_id = $this->rowIdFromDtoIdForcedMatches($dto_id);
	    if ($row_id) return $row_id;
	    return $this->_rowIdFromDtoId($dto_id);
	}
	
	/**
	 * Esta es la función que debe sobreescribirse para modificar el comportamiento del
	 * matcher.
	 */
	public function _rowIdFromDtoId($dto_id)
	{
	    if (!$this->persist) return null;
	    return $this->getMatch($dto_id);
	}
	
	/**
	 * Sólo debe usarse esta función en caso de que dto tenga suficiente información
	 * como en el momento de la creación/actualización.
	 */
	public function rowIdFromDto($dto)
	{
	    return $this->rowIdFromDtoId($this->dtoId($dto));
	}
	
	
	/**
	 * Soporte multimatch para multiples actualizaciones por ejemplo, para varios productos con la misma referencia.
	 * XXX: Variantes rowIdFrom requeriran algo de información extra para discriminar, por ejemplo a la hora
	 * de establecer relaciones entre elementos por dtoId (categorias padres e hijas, productos con combinaciones ...)
	 */
	public function rowIdsFromDtoId($dto_id) { $rid = $this->rowIdFromDtoId($dto_id); return $rid? array($rid) : $rid; }
	//public function _rowIdsFromDtoId($dto_id) { $rid = $this->_rowIdFromDtoId($dto_id); return $rid? array($rid) : $rid; } // No se usa
	public function rowIdsFromDto($dto) { $rid = $this->rowIdFromDto($dto); return $rid? array($rid) : $rid; }
	
	public function dtoIdStrFromRowIdForcedMatches($row_id)
	{
	    if ($this->direct_match) return (empty($row_id)? null : strval($row_id));
	    if (!empty($this->forced_maches_reverse))
	    {
	        if (isset($this->forced_maches_reverse[$row_id]))
	            return $this->dtoIdToStr($this->forced_maches_reverse[$row_id]);
	    }
	    return null;
	}
	
	public function dtoIdStrFromRowId($row_id)
	{
	    $dto_id_str = $this->dtoIdStrFromRowIdForcedMatches($row_id);
	    if ($dto_id_str) return $dto_id_str;
	    return $this->_dtoIdStrFromRowId($row_id);
	}
	
    /**
     * Esta es la función que debe sobreescribirse para modificar el comportamiento del
     * matcher.
     */
	public function _dtoIdStrFromRowId($row_id)
	{
		if (!$this->persist) return null;
		return $this->getReverseMatch($row_id);
	}
	
	public function dtoIdFromRowId($row_id)
	{
	    return $this->strToDtoId($this->dtoIdStrFromRowId($row_id));
	}

	/**
	 * Genera un dto_id_str a partir del row_id. Útil para la generación de dto_id durante la extracción.
	 */
	public function generateDtoIdStrFromRowId($row_id)
	{
	    return strval($this->genidinc + $row_id);
	}
	
	public function updateMatch($dto_id, $row_id)
	{
		if (!$this->persist) return;

		$dto_id_str = Fs2psTools::dbEscape($this->dtoIdToStr($dto_id));
		if ($this->cache) {
		    if (isset($this->cache_rowid_by_dtoidstr[$dto_id_str])) {
    		    $old_row_id = $this->cache_rowid_by_dtoidstr[$dto_id_str];
    		    if ($old_row_id!=$row_id) unset($this->cache_dtoid_by_rowid[$old_row_id]);
		    }
		    $this->cache_rowid_by_dtoidstr[$dto_id_str] = $row_id;
		    $this->cache_dtoid_by_rowid[$row_id] = $dto_id_str;
		}
		if ($this->getMatch($dto_id, TRUE))
		{
			return Fs2psTools::dbExec('
				update `@DB_fs2ps_match`
				set row_id=\''.$row_id.'\', entity=\''.$this->entity.'\', uploaded=1
				where
					`table`=\''.$this->table.'\' and
					(`entity`=\''.$this->entity.'\' or `entity` is null) and
					dto_id=\''.$dto_id_str.'\'
			');
		}
		else
		{
			return Fs2psTools::dbExec('
				insert into `@DB_fs2ps_match` (`table`, `entity`, dto_id, row_id, uploaded)
				values (\''.$this->table.'\', \''.$this->entity.'\', \''.$dto_id_str.'\', \''.$row_id.'\', 1)
			');
		}
		
	}
	
	public function updateReverseMatch($dto_id, $row_id)
	{
	    if (!$this->persist) return;
	    
	    $dto_id_str = Fs2psTools::dbEscape($this->dtoIdToStr($dto_id));
	    if ($this->cache) {
	        if (isset($this->cache_dtoid_by_rowid[$row_id])) {
    	        $old_dto_id_str = $this->cache_dtoid_by_rowid[$row_id];
    	        if ($old_dto_id_str!=$dto_id_str) unset($this->cache_rowid_by_dtoidstr[$old_dto_id_str]);
	        }
	        $this->cache_dtoid_by_rowid[$row_id] = $dto_id_str;
	        $this->cache_rowid_by_dtoidstr[$dto_id_str] = $row_id;
	    }
	    
	    if ($this->getReverseMatch($row_id, TRUE)!==null)
	    {
	        return Fs2psTools::dbExec('
				update `@DB_fs2ps_match`
				set dto_id=\''.$dto_id_str.'\', entity=\''.$this->entity.'\', uploaded=1
				where
					`table`=\''.$this->table.'\' and
					(`entity`=\''.$this->entity.'\' or `entity` is null) and
					row_id=\''.$row_id.'\'
			');
	    }
	    else
	    {
	        // Evitamos errors cuando ya existe match con mismo dto_id pero distintoo row_id
	        if ($this->getMatch($dto_id_str, TRUE)!==null) return TRUE;
	        
	        return Fs2psTools::dbExec('
				insert into `@DB_fs2ps_match` (`table`, `entity`, dto_id, row_id, uploaded)
				values (\''.$this->table.'\', \''.$this->entity.'\', \''.$dto_id_str.'\', \''.$row_id.'\', 1)
			');
	    }
	    
	}

	public static function clearUploadedMarks($task)
	{
	    // Eliminamos Matchings a entidades no persistidas en BD
	    Fs2psTools::dbExec('delete from @DB_fs2ps_match where`table`=\'\'');
	    
	    // Eliminamos refs. de match si se eliminan datos en PS
		$rows = Fs2psTools::dbSelect(
			'select distinct `table`, `entity` from `@DB_fs2ps_match` where `table`<>\'\''
		);
		foreach ($rows as $row)
		{
			$table = $row['table'];
			$entity = $row['entity'];
			try {
                $id_field = Fs2psObjectModel::idForTable($table);
			} catch (Fs2psException $e) {
			    // Eliminamos registro rxxx creado por error
			    Fs2psTools::dbExec('delete from `@DB_fs2ps_match` where `table`=\''.$table.'\'');
			    continue;
			}
			$where = '';

			// Evitamos eliminar atributos porque pueden
			// haberse mapeado aunque aún no existan durante la extracción.
			if ($entity=='colours' || $entity=='sizes')
			{
			    $attrGrpMatcher = Fs2psMatcherFactory::get($task, 'attribute_groups');
			    $taxonomy = $attrGrpMatcher->taxonomyFromDtoId(strtoupper($entity));
			    $where = 'inner join @DB_term_taxonomy tt on tt.term_id=t.term_id and tt.taxonomy=\''.$taxonomy.'\'';
			}
			
			// Purga de matches que han dejado de existir
			Fs2psTools::dbExec('
				delete from @DB_fs2ps_match
				where
					`table`=\''.$table.'\' and
					(`entity`=\''.$entity.'\' or `entity`is null) and
					row_id not in (
						select t.'.$id_field.' from `@DB_'.$table.'` t '.$where.'
					)
			');
		}
		
		// Reseteamos marca uploaded
		Fs2psTools::dbExec('
			update `@DB_fs2ps_match`
			set uploaded = 0
		');
	}
	
	
	/**
	 *  Eliminamos refs. de match duplicadas de las cuales sólo una tiene uploaded=1
	 *  Esto puede pasar si cambia el valor de la referencia en Prestashop o la política de matching.
	 *  Ej:   dto_id      row_id       uploaded
	 *           001          11              0  <- Esta se debe borrar
	 *           003          11              1  <- Esta se debe conservar
	 *           005          11              0  <- Esta se debe borrar
	 */
	public static function deleteRepeatedZeroMarks()
	{
	    Fs2psTools::dbExec('
			delete  r0
			from
			    @DB_fs2ps_match r1
			    inner join @DB_fs2ps_match r0 on r0.`table`=r1.`table` and r0.entity=r1.entity and r0.row_id=r1.row_id and r0.uploaded=0
			where r1.uploaded=1
		');
	}

}

class Fs2psDto2RowOidMatcher extends Fs2psDto2RowMatcher
{
    protected $dto_oid_fields;
    protected $row_oid_field;
    
    protected $ignorepersist;
    protected $oidfirst;
    
    protected $multimatch;
    
    
    public function __construct($entity, $table, $row_id_field, $dto_id_fields, $dto_oid_fields, $row_oid_field, $persist=false, $cache=false, $multimatch=false)
    {
        $this->dto_oid_fields = $dto_oid_fields;
        $this->row_oid_field = $row_oid_field;
        $this->multimatch = $multimatch;
        parent::__construct($entity, $table, $row_id_field, $dto_id_fields, $persist, $cache);
    }
    
    public function reloadCfg($cfg)
    {
        $updpart = strtoupper($this->entity);
        parent::reloadCfg($cfg);
        
        $match_preference = $cfg->get($updpart.'_MATCH_PREFERENCE');
        $this->ignorepersist = $match_preference=='ignorepersist';
        $this->oidfirst = $match_preference=='oidfirst';
    }
    
    // Por defecto no habrá oid hasta que se implementen estos métodos
    public function _rowIdFromOid($oid) { return null; }
    public function _oidStrFromRowId($row_id) { return null; }
    
    public function dtoOid($dto) {
        if (isset($dto['_oid'])) return $dto['_oid'];
        $oid = $this->idFromFields($dto, $this->dto_oid_fields);
        $dto['_oid'] = $oid;
        return $oid;
    }
    
    /**
     * Reemplazo de rowIdFromDto/rowIdFromDtoId teniendo en cuenta valor de oid
     */
    public function rowIdFromDtoOid($dto_id, $oid)
    {
        $row_id = $this->rowIdFromDtoIdForcedMatches($dto_id);
        if ($row_id) return $row_id;
        
        if (!$this->oidfirst && !$this->ignorepersist) {
            $row_id = parent::_rowIdFromDtoId($dto_id);
            if ($row_id) return $row_id;
        }
        
        if ($oid!==null)
        {
            $row_id = $this->_rowIdFromOid($oid);
            if ($row_id) return $row_id;
        }
        
        if ($this->oidfirst) {
            $row_id = parent::_rowIdFromDtoId($dto_id);
            if ($row_id) return $row_id;
        }
        
        return $row_id;
    }
    
    /**
     * Sólo debe usarse esta función en caso de que dto tenga suficiente información
     * como en el momento de la creación/actualización.
     */
    public function rowIdFromDto($dto)
    {
        return $this->rowIdFromDtoOid($this->dtoId($dto), $this->dtoOid($dto));
    }
    
    /**
     * Cuando se genera dto_id (en modo extracción, por ejemplo), tomamos el valor de oid
     */
    public function _dtoIdStrFromRowId($row_id)
    {
        if (!$this->oidfirst && !$this->ignorepersist) {
            $dto_id = parent::_dtoIdStrFromRowId($row_id);
            if (!empty($dto_id)) return $dto_id;
        }
        
        // Generamos dto_id a partir de oid
        $oid_str = $this->_oidStrFromRowId($row_id);
        if (!empty($oid_str)) return $oid_str;
        
        if ($this->oidfirst) {
            $dto_id = parent::_dtoIdStrFromRowId($row_id);
            if (!empty($dto_id)) return $dto_id;
        }
        
        return null;
    }
    
    
    //////////
    // Multimatch por oid
    //
    // Reemplazo de rowIdsFromDto teniendo en cuenta sólo el valor de oid.
    // No reemplazamos rowIdsFromDtoId porque generalmente no sabremos el oid a partir del dto_id.
    // Actualmente sólo usamos rowIdsFromDto en Fs2psStockablesUpdater.
    
    public function _rowIdsFromOid($oid) {
        $row_id = $this->_rowIdFromOid($oid);
        return $row_id? array($row_id) : array(); 
    }
    
    /**
     * Sólo debe usarse esta función en caso de que el dto tenga información del oid.
     */
    public function rowIdsFromDto($dto)
    {
        if ($this->multimatch) {
            return $this->_rowIdsFromOid($this->dtoOid($dto));
        } else {
            $row_id = $this->rowIdFromDto($dto);
            return $row_id? array($row_id) : array();
        }
    }
    
}
   
class Fs2psDto2RowDirectMatcher extends Fs2psDto2RowOidMatcher
{
    public function __construct($entity, $table, $row_id_field, $dto_id_fields, $persist=false, $cache=false)
    {
        parent::__construct($entity, $table, $row_id_field, $dto_id_fields, $dto_id_fields, null, $persist, $cache);
    }
    
    // A priori consideramos que son del mismo tipo dto_id y row_id
    public function _rowIdFromOid($oid) { return empty($oid)? null : $oid; }
    public function _oidStrFromRowId($row_id) { return $row_id; }
}

class Fs2psDto2PostDirectMatcher extends Fs2psDto2RowDirectMatcher
{
    public function __construct($entity, $dto_id_fields, $persist=false, $cache=false)
    {
        parent::__construct($entity, 'posts', null, $dto_id_fields, $persist, $cache);
    }
    
    public function _rowIdFromOid($oid) { return ((int)$oid)? (int)$oid : null; }
    public function _oidStrFromRowId($row_id) { return $this->dtoIdToStr($row_id); }
}

class Fs2psDto2PostBasicMatcher extends Fs2psDto2RowMatcher
{
    public function __construct($entity, $dto_id_fields, $persist=false, $cache=false)
    {
        parent::__construct($entity, 'posts', null, $dto_id_fields, $persist, $cache);
    }
}

class Fs2psDto2PostMatcher extends Fs2psDto2RowOidMatcher
{
    protected $post_type = null;
    protected static $POST_TYPE_BY_ENTITY = array(
        'products' => array('product'),
        'combinations' => array('product_variation'),
        // orders ...
    );
    
    public function __construct($entity, $dto_id_fields, $dto_oid_fields, $row_oid_field, $persist=false, $cache=false, $multimatch=false)
    {
        parent::__construct($entity, 'posts', null, $dto_id_fields, $dto_oid_fields, $row_oid_field, $persist, $cache, $multimatch);
        if (array_key_exists($entity, self::$POST_TYPE_BY_ENTITY)) {
            $this->post_type = self::$POST_TYPE_BY_ENTITY[$entity];
        }
    }
    
    public function _rowIdFromOid($oid)
    {
        $oid_sql = Fs2psTools::dbEscape($this->dtoIdToStr($oid));
        
        // Avoid matchings if oid is empty
        if (empty($oid_sql)) return null;
        
        return (int)Fs2psTools::dbValue('
			SELECT post_id
			FROM
				`@DB_postmeta` pm
				inner join `@DB_posts` p on p.ID=pm.post_id
			where 
                pm.meta_key=\''.$this->row_oid_field.'\' and pm.meta_value= \''.$oid_sql.'\'
                '.($this->post_type?' and p.post_type in (\''.implode('\', \'', $this->post_type).'\')' : '').'
		');
    }
    
    public function _rowIdsFromOid($oid)
    {
        $oid_sql = Fs2psTools::dbEscape($this->dtoIdToStr($oid));
        
        // Avoid matchings if oid is empty
        if (empty($oid_sql)) return null;
        
        $sql = '
			SELECT post_id
			FROM
				`@DB_postmeta` pm
				inner join `@DB_posts` p on p.ID=pm.post_id
			where
                pm.meta_key=\''.$this->row_oid_field.'\' and pm.meta_value= \''.$oid_sql.'\'
                '.($this->post_type?' and p.post_type in (\''.implode('\', \'', $this->post_type).'\')' : '').'
		';
         return array_column(Fs2psTools::dbSelect($sql), 'post_id');
    }
    
    public function _oidStrFromRowId($row_id)
    {
        return Fs2psTools::dbValue('
			SELECT pm.meta_value
			FROM `@DB_postmeta` pm
            inner join `@DB_posts` p on p.ID=pm.post_id
			where pm.meta_key=\''.$this->row_oid_field.'\' and pm.post_id =\''.$row_id.'\'
            '.($this->post_type?' and p.post_type in (\''.implode('\', \'', $this->post_type).'\')' : '').'
		');
    }
}

class Fs2psDto2PostRefMatcher extends Fs2psDto2PostMatcher
{
    public function __construct($entity, $dto_id_fields, $persist=false, $cache=false, $multimatch=false)
    {
        parent::__construct($entity, $dto_id_fields, $dto_id_fields, '_sku', $persist, $cache, $multimatch);
    }
    
    // Fs2psDto2RowRefMatcher es un caso especial de Fs2psDto2RowOidMatcher en el que se cumple que dto_id_fields = dto_oid_fields
    public function _rowIdFromDtoId($dto_id)
    {
        return $this->rowIdFromDtoOid($dto_id, $dto_id);
    }
}

class Fs2psDto2PostPRefMatcher extends Fs2psDto2PostMatcher
{
    public function __construct($entity, $dto_id_fields, $persist=false, $cache=false, $multimatch=false)
    {
        parent::__construct($entity, $dto_id_fields, array('pref'), '_sku', $persist, $cache, $multimatch);
    }
}

class Fs2psDto2PostEanMatcher extends Fs2psDto2PostMatcher
{
    public function __construct($entity, $dto_id_fields, $persist=false, $cache=false, $multimatch=false)
    {
        parent::__construct($entity, $dto_id_fields, array('ean'), '_wpm_gtin_code', $persist, $cache, $multimatch);
    }

	public function reloadCfg($cfg) {
		$this->row_oid_field = $cfg->get('EAN_METAKEY', '_wpm_gtin_code');
		parent::reloadCfg($cfg);
	}
}

class Fs2psDto2MultiPostRefMatcher extends Fs2psDto2PostRefMatcher
{
    public function __construct($entity, $dto_id_fields, $persist=false, $cache=false)
    {
        parent::__construct($entity, $dto_id_fields, $persist, $cache, true);
    }
}

class Fs2psDto2MultiPostPRefMatcher extends Fs2psDto2PostPRefMatcher
{
    public function __construct($entity, $dto_id_fields, $persist=false, $cache=false)
    {
        parent::__construct($entity, $dto_id_fields, $persist, $cache, true);
    }
}

class Fs2psDto2MultiPostEanMatcher extends Fs2psDto2PostEanMatcher
{
    public function __construct($entity, $dto_id_fields, $persist=false, $cache=false)
    {
        parent::__construct($entity, $dto_id_fields, $persist, $cache, true);
    }
}


class Fs2psDto2TermMatcher extends Fs2psDto2RowOidMatcher
{
    
    public $taxonomy = null;
    
    
    public function __construct($entity, $taxonomy, $persist=true, $cache=false)
    {
        $this->taxonomy = $taxonomy && taxonomy_exists($taxonomy)? $taxonomy : null;
        parent::__construct($entity, 'terms', null, null, null, null, $persist, $cache);
    }
    
    /**
     * Capacidad para indicar una taxonomía personalizada a través de la configuración
     */
    public function reloadCfg($cfg) {
        $taxonomy = $cfg->get(strtoupper($this->entity).'_TAXONOMY');
        if ($taxonomy!==null) { // Establecemos la taxonomía si se configura una
            $this->taxonomy = taxonomy_exists($taxonomy)? $taxonomy : null;
        }
        parent::reloadCfg($cfg);
    }
    
    
    /**
     * El identificador de un term debe ser de tipo entero.
     * En caso contrario las funciones de Wordpress pensaran que se
     * trata del slug y no del id.
     */
    public function rowIdFromDtoId($dto_id)
    {
        $row_id = parent::rowIdFromDtoId($dto_id);
        return $row_id? intval($row_id) : $row_id;
    }
    
    /* Usamos comportamiento getMatch por defecto
     public function _rowIdFromDtoId($dto_id)
     {
     //$term = get_term_by('slug', $this->dtoIdToStr($dto_id), $this->taxonomy);
     $terms = Fs2PsTools::wpErr(get_terms(array(
     'get'                    => 'all',
     'number'                 => 1,
     'taxonomy'               => $this->taxonomy,
     'update_term_meta_cache' => false,
     'orderby'                => 'none',
     'suppress_filter'        => true,
     'slug'                   => $this->dtoIdToStr($dto_id),
     )));
     if (empty($terms)) return null;
     $term = array_shift($terms);
     
     return $term? $term->term_id : null;
     }
     */
    
    // protected slugByRowId = array();
    // TODO ACÍ: Implementar stugFromRowId
}
