<?php
/**
* LICENCIA
*
* Este programa se propociona "tal cual", sin garantía de ningún tipo más allá del soporte
* pactado a la hora de adquirir el programa.
*
* En ningún caso los autores o titulares del copyright serán responsables de ninguna
* reclamación, daños u otras responsabilidades, ya sea en un litigio, agravio o de otro
* modo, que surja de o en conexión con el programa o el uso u otro tipo de acciones
* realizadas con el programa.
*
* Este programa no puede modificarse ni distribuirse sin el consentimiento expreso del autor.
*
*    @author    Carlos Fillol Sendra <festeweb@festeweb.com>
*    @copyright 2014 Fes-te web! - www.festeweb.com
*    @license   http://www.festeweb.com/static/licenses/fs2ps_1.1.0.txt
*/

include_once(dirname(__FILE__).'/Fs2psException.php');
include_once(dirname(__FILE__).'/Fs2psTools.php');
include_once(dirname(__FILE__).'/Fs2psObjectModels.php');

class Fs2psDisabler
{

	protected $task;
	protected $nprocessed = 0;
	protected $ntotal = 0;
	protected $ndisabled = 0;

	protected $name;
	protected $table;

	public function __construct($task, $name, $table)
	{
		$this->task = $task;
		$this->name = $name;
		$this->table = $table;
		$this->row_id_field = Fs2psObjectModel::idForTable($table);
	}

	protected function loadDisabledByTable()
	{
		return Fs2psTools::dbSelect('
			SELECT dto_id, row_id from `@DB_fs2ps_match`
			WHERE `table`=\''.$this->table.'\' and `entity`=\''.$this->name.'\'  and uploaded=0
		');
	}

	protected function disable($id)
	{
	    throw new Fs2psNotImplemented();
	}

	public function process()
	{
		$cfg = $this->task->cfg;
		$disable = $cfg->get('DISABLE_'.strtoupper($this->name), false);
		if (!$disable)
		{
			$this->task->log($this->name.': 0 deshabilitados');
			return;
		}
		
		$rows = $this->loadDisabledByTable();
		$this->ntotal = count($rows);

		$idx = 0;
		foreach ($rows as $row)
		{

			try
			{

				if ($this->disable($row['row_id']))	$this->ndisabled++;

			} catch (Exception $e)
			{
				$msg = 'No se pudo deshabilitar el objeto: '.$this->table.' ('.$row['dto_id'].')';
				if (is_a($e, 'PrestashopException'))
					$msg = $msg.' - '.$e->getMessage();

				$task = $this->task;
				if ($task->stop_on_error)
					throw new Fs2psException($msg, $e);
				else
					$this->task->log('ERROR: '.$msg);
			}

			$idx++;
			$this->nprocessed = $idx;
		}

		$this->task->log($this->name.': '.$this->ndisabled.' deshabilitados');
	}
}

class Fs2psFastPostDisabler extends Fs2psDisabler
{
    
    protected static $POSSIBLE_DISABLED_STATUS = array('trash', 'draft');
    
    protected $disabled_status;

	// Do not change status when disabling if actual status is one of these
	protected $dont_disable_status; // Ex: array('trash', 'draft');
    
	public function __construct($task, $name, $disabled_status='draft')
	{
	    if (!in_array($disabled_status, self::$POSSIBLE_DISABLED_STATUS)) {
	        throw new Fs2psException('No se indicó un estado deshabilitación válido: '.$disabled_status);
	    }
	    $this->disabled_status = $disabled_status;

		$cfg = $task->cfg;
		$this->dont_disable_status = $cfg->get('DONT_DISABLE_PRODUCTS_WHERE_STATUS');
	    
		parent::__construct($task, $name, 'posts');
	}

	protected function getPossibleDisabledStatus() {
		$possibleDisabledStatus = self::$POSSIBLE_DISABLED_STATUS;
		if(!empty($this->dont_disable_status))
			foreach ($this->dont_disable_status as $status)
				array_push($possibleDisabledStatus, $status);
		return $possibleDisabledStatus;
	}

	protected function dontDisableStatusWhere() {
		$dont_disable_status = $this->dont_disable_status;
		if (!empty($dont_disable_status)) 
			return 'WHERE p.post_status not in ('.Fs2psTools::dbInStr($dont_disable_status).')';
		return ''; // Devolvemos String vacio para no perjudicar la consulta
	}

	public function process()
	{
		$cfg = $this->task->cfg;
		$disable = $cfg->get('DISABLE_'.strtoupper($this->name), false);
		if (!$disable)
		{
			$this->task->log($this->name.': 0 deshabilitados');
			return;
		}
		
		$nactive_sql = '
            SELECT count(1)
            FROM `@DB_'.$this->table.'` p
            INNER JOIN `@DB_fs2ps_match` m on m.row_id=p.'.$this->row_id_field.' and m.`table`=\''.$this->table.'\' and m.entity=\''.$this->name.'\'
            WHERE not p.post_status in ('.Fs2psTools::dbInStr($this->getPossibleDisabledStatus()).')
		';
		
		$nbefore = Fs2psTools::dbValue($nactive_sql);
		Fs2psTools::dbExec('
			UPDATE `@DB_'.$this->table.'` p
			INNER JOIN `@DB_fs2ps_match` m on m.row_id=p.'.$this->row_id_field.' and m.`table`=\''.$this->table.'\' and m.entity=\''.$this->name.'\' and m.uploaded=0
			SET p.post_status=\''.$this->disabled_status.'\'
			'.$this->dontDisableStatusWhere().'
		');
		// TODO Moisés: Si dont_disable_status no está vacío incluir WHERE en el UPDATE
		$nafter = Fs2psTools::dbValue($nactive_sql);

		$ndisabled = $nbefore - $nafter;
		$this->task->log($this->name.': '.$ndisabled.' deshabilitados');
	}
}

class Fs2psFastHideDisabler extends Fs2psDisabler
{
    
    protected static $POSSIBLE_DISABLED_STATUS = array('private');
    
    protected $disabled_status;
    
    public function __construct($task, $name, $disabled_status='private')
    {
        if (!in_array($disabled_status, self::$POSSIBLE_DISABLED_STATUS)) {
            throw new Fs2psException('No se indicó un estado deshabilitación válido: '.$disabled_status);
        }
        $this->disabled_status = $disabled_status;
        
        parent::__construct($task, $name, 'posts');
    }
    
    public function process()
    {
        $cfg = $this->task->cfg;
        $hide = $cfg->get('DISABLE_'.strtoupper($this->name), false);
        if (!$hide)
        {
            $this->task->log($this->name.': 0 ocultados');
            return;
        }
        
		$hiden_term_ids = Fs2psTools::dbValue('
			select group_concat(t.term_id)
			from @DB_term_taxonomy tt
			inner join @DB_terms t on t.term_id=tt.term_id
			where tt.taxonomy=\'product_visibility\' and t.name in (\'exclude-from-search\', \'exclude-from-catalog\')
		');
		
		$nactive_sql = '
			SELECT count(1)
			FROM `@DB_'.$this->table.'` p
			INNER JOIN `@DB_fs2ps_match` m on m.row_id=p.'.$this->row_id_field.' and m.`table`=\''.$this->table.'\' and m.entity=\''.$this->name.'\'
			LEFT JOIN (
				select distinct tr.object_id
				from @DB_terms t
				inner join @DB_term_relationships tr on tr.term_taxonomy_id=t.term_id
				where t.term_id in ('.$hiden_term_ids.')
				group by tr.object_id
				having count(1)>=2
			) h on h.object_id=p.ID
			WHERE h.object_id is null
		';
		
        $nbefore = Fs2psTools::dbValue($nactive_sql);
        Fs2psTools::dbExec('
			INSERT INTO @DB_term_relationships (object_id, term_taxonomy_id, term_order)
			SELECT p.ID, t.term_id ,0
			FROM (
				select t.term_id
				from @DB_term_taxonomy tt
				inner join @DB_terms t on t.term_id=tt.term_id
				where tt.taxonomy=\'product_visibility\' and t.name in (\'exclude-from-search\', \'exclude-from-catalog\')
			) t
			CROSS JOIN `@DB_posts` p
			INNER JOIN `@DB_fs2ps_match` m on m.row_id=p.'.$this->row_id_field.' and m.`table`=\''.$this->table.'\' and m.entity=\''.$this->name.'\' and m.uploaded=0
			WHERE 1=1 -- XXX cfillol: WTF! Sin esto da syntax error
			ON DUPLICATE KEY UPDATE object_id=p.ID, term_taxonomy_id=t.term_id
		');
        $nafter = Fs2psTools::dbValue($nactive_sql);
        
        $ndisabled = $nbefore - $nafter;
        $this->task->log($this->name.': '.$ndisabled.' ocultados');
    }
}

class Fs2psPostDisabler extends Fs2psDisabler
{
    public function __construct($task, $name)
    {
        parent::__construct($task, $name, 'posts');
    }

	public function disable($id) 
	{
	    // TODO cfillol: Más lento que el caballo del malo
	    // Optimizar post_status -> 'trash'
		return wp_trash_post($id)? true : false;
	}
}

class Fs2psPostDeleteDisabler extends Fs2psDisabler
{
    public function __construct($task, $name)
    {
        parent::__construct($task, $name, 'posts');
    }
    
    public function disable($id)
    {
        return wp_delete_post($id, true)? true : false;
    }
}

class Fs2psProductFastHideDisabler extends Fs2psFastHideDisabler
{
    public function __construct($task, $name)
    {
        parent::__construct($task, $name, 'private');
    }
}

class Fs2psProductDeleteFastDisabler extends Fs2psFastPostDisabler
{
    public function __construct($task, $name)
    {
        parent::__construct($task, $name, 'trash');
    }
}

/*
class Fs2psTermDisabler extends Fs2psDisabler
{
	protected $taxonomy = null;

	public function __construct($task, $name, $taxonomy=null)
	{
		parent::__construct($task, $name, 'terms', array('ref'));

		$this->taxonomy = $taxonomy;
	}
}
*/

/* 
 * No deshabilitamos las entidades que no sabemos cómo deshabilitar.
 * TODO: https://wordpress.stackexchange.com/questions/257691/is-there-a-way-to-disable-a-term-rather-than-deleting-it
 */
class Fs2psIgnoreDisabler extends Fs2psDisabler
{
	
	public function __construct($task, $name, $table)
	{
		$this->task = $task;
		$this->name = $name;
	}

	public function process()
	{
		$this->task->log($this->name.': 0 deshabilitados');
	}
}

class Fs2psProductDisabler extends Fs2psFastPostDisabler {}
class Fs2psProductTrashDisabler extends Fs2psFastPostDisabler {
    public function __construct($task, $name) { parent::__construct($task, $name, 'trash'); }
}
class Fs2psProductDisableHookDisabler extends Fs2psPostDisabler { }
class Fs2psProductDeleteHookDisabler extends Fs2psPostDeleteDisabler { }

class Fs2psManufacturerDisabler extends Fs2psIgnoreDisabler
{
	public function __construct($task, $name)
	{
		parent::__construct($task, $name, 'manufacturer', null);
	}
}

class Fs2psSupplierDisabler extends Fs2psIgnoreDisabler
{
	public function __construct($task, $name)
	{
		parent::__construct($task, $name, 'supplier', null);
	}
}

class Fs2psCategoryDisabler extends Fs2psIgnoreDisabler
{
	public function __construct($task, $name)
	{
		parent::__construct($task, $name, 'category', null);
	}
}
