<?php
/**
* LICENCIA
*
* Este programa se propociona "tal cual", sin garantía de ningún tipo más allá del soporte
* pactado a la hora de adquirir el programa.
*
* En ningún caso los autores o titulares del copyright serán responsables de ninguna
* reclamación, daños u otras responsabilidades, ya sea en un litigio, agravio o de otro
* modo, que surja de o en conexión con el programa o el uso u otro tipo de acciones
* realizadas con el programa.
*
* Este programa no puede modificarse ni distribuirse sin el consentimiento expreso del autor.
*
*    @author    Carlos Fillol Sendra <festeweb@festeweb.com>
*    @copyright 2014 Fes-te web! - www.festeweb.com
*    @license   http://www.festeweb.com/static/licenses/fs2ps_1.1.0.txt
*/

include_once(dirname(__FILE__).'/Fs2psTask.php');
include_once(dirname(__FILE__).'/Fs2psExtractors.php');

class Fs2psCombiasprodDownloadCatalogTask extends Fs2psExtractorTask
{
	public function __construct($mng, $cmd)
	{
		parent::__construct('download_catalog', $mng, $cmd);
	}
	
	public function preExecute()
	{
	    $cfg = $this->cfg;
	    if ($cfg->get('DOWNLOAD_SECTIONS', true)) $this->addExtractor('sections', 'Fs2psSectionExtractor');
	    if ($cfg->get('DOWNLOAD_FAMILIES', true)) $this->addExtractor('families', 'Fs2psFamilyExtractor');
	    $this->addExtractor('products', 'Fs2psCombiasprodProductExtractor');
	}
	
}

class Fs2psCombiasprodProductExtractor extends Fs2psProductExtractor
{
    protected $familyLevel;
    
    public function __construct($task, $name)
    {
        parent::__construct($task, $name);
        $this->matcher = new Fs2psCombiasprodRefMatcher($task, $name, array('ref'));
    }
    
    protected function reloadCfg() {
        parent::reloadCfg();

        $cfg = $this->task->cfg;
        $download_catalog = $cfg->get('DOWNLOAD_CATALOG', '');
        $download_products = $cfg->get('DOWNLOAD_PRODUCTS', 'true');
        if ($download_products === true) $download_products = 'true';
        if ($download_catalog) $download_products = $download_products.','.$download_catalog;
        
        $this->onlyactive = strpos($download_products, 'onlyactive') !== false;
        $this->nesku = strpos($download_products, 'nesku') !== false;
        $this->nepsku = strpos($download_products, 'nepsku') !== false;
        $this->neporsku = strpos($download_products, 'neporsku') !== false;
        $this->neean = strpos($download_products, 'neean') !== false;
        $this->nocombi = strpos($download_products, 'nocombi') !== false;
        $this->products = array_filter(array_map('intval', preg_split("/ *, */", $download_products)));

        $this->ean_metakey = $cfg->get('EAN_METAKEY', 'false');

        $this->download_longdescrip = $cfg->get('DOWNLOAD_LONGDESCRIP');
        $this->download_description_short = $cfg->get('DOWNLOAD_DESCRIPTION_SHORT');

        $familyExtractor = $this->task->getExtractor('families');
        $this->familyLevel = $familyExtractor? $familyExtractor->getLevelFromDownloadCfg($cfg->get('DOWNLOAD_FAMILIES', true)) : null;
    }
    
    protected function getAfterDateWhereCondition()
    {
        $where = array();
        
        if (empty($this->products)) {
            if ($this->onlyactive) $where[] = 'p.post_status=\'publish\'';
            
            if (!empty($this->task->cmd['after'])) {
                $after_str =  Fs2psTools::date2db(Fs2psTools::dto2date($this->task->cmd['after']));
                $where[] = 'p.post_modified>\''.$after_str.'\'';
            }
            
            if (!empty($this->task->cmd['created_after'])) {
                $created_after_str =  Fs2psTools::date2db(Fs2psTools::dto2date($this->task->cmd['created_after']));
                $where[] = 'p.post_date>\''.$created_after_str.'\'';
            }
            
            if (!empty($this->task->cmd['until'])) {
                $until_str =  Fs2psTools::date2db(Fs2psTools::dto2date($this->task->cmd['until']));
                $where[] = 'p.post_modified<=\''.$until_str.'\'';
            }
        } else {
            $where[] = 'p.ID in ('.implode(',', $this->products).')';
        }
            
        if ($this->nocombi) $where[] = 'pa.ID is null';
        
        return join(" and ", $where);
    }
    
    protected function buildSql()
    {
        $ml_joins = '';
        if ($this->multilang_plugin=='wpml') {
            $ml_joins = 'inner join `@DB_icl_translations` t ON t.element_id=p.ID AND t.element_type=CONCAT(\'post_\', p.post_type) and t.language_code=\''.$this->default_lang.'\'';
        }

        $ean_metakey_query = "";
        if ($this->ean_metakey != false) {
            $ean_metakey_query = "(select max(meta_value) from @DB_postmeta  where post_id=IFNULL(pa.ID,p.ID) and meta_key='".$this->ean_metakey."')";
        }
        
        $where = array();
        if ($this->nesku) $where[] = 'p.sku>\'\'';
        if ($this->nepsku) $where[] = 'p.parent_sku>\'\'';
        if (!($this->nesku || $this->nepsku) && $this->neporsku) $where[] = '(p.sku>\'\' or p.parent_sku>\'\')';
        if ($this->neean) $where[] = 'p.ean>\'\'';
        $where = empty($where)? '' : 'WHERE '.join(" and ", $where);
        
        $where_date =  $this->getAfterDateWhereCondition();

        
        return '
            select * from (
    			SELECT
                    IFNULL(pa.ID,p.ID) as id,
                    IFNULL(pa.post_parent,p.ID) as product_id,
    			    p.post_date,
    			    p.post_modified,
    			    CONCAT_WS(\' \',
                        p.post_title,
                        (
                            SELECT UPPER(GROUP_CONCAT(pm.meta_value ORDER BY meta_id DESC SEPARATOR \' \'))
                            FROM @DB_postmeta pm 
                            WHERE pm.post_id=pa.ID and pm.meta_key like \'attribute_%\'
                            GROUP BY pm.post_id
                        )
                    ) as post_title,
    				p.post_status,
                    
					'.($this->download_longdescrip? 'p.post_content' : '\'\'').' as longdescrip, 
                    '.($this->download_description_short?  'p.post_excerpt' : '\'\'').' as descrip,

                    -- Usamos max para evitar Subquery returns more than 1 row. Alguna vez han aparecido repetiones aunque con el mismo valor.
    			    (select max(meta_value) from @DB_postmeta where post_id=IFNULL(pa.ID,p.ID) and meta_key=\'_regular_price\') as price,
    				(select max(meta_value) from @DB_postmeta where post_id=IFNULL(pa.ID,p.ID) and meta_key=\'_sale_price\') as sale_price,
    			    (select max(meta_value) from @DB_postmeta where post_id=IFNULL(pa.ID,p.ID) and meta_key=\'_sku\') as sku,
                    (select max(meta_value) from @DB_postmeta where post_id=p.ID and meta_key=\'_sku\') as parent_sku,
    			    (select max(meta_value) from @DB_postmeta where post_id=IFNULL(pa.ID,p.ID) and meta_key=\'_manage_stock\') as manage_stock,
    			    (select max(meta_value) from @DB_postmeta where post_id=IFNULL(pa.ID,p.ID) and meta_key=\'_stock\') as stock,
    			    (select max(meta_value) from @DB_postmeta where post_id=p.ID and meta_key=\'_tax_status\') as tax_status,
    			    (select max(meta_value) from @DB_postmeta where post_id=p.ID and meta_key=\'_tax_class\') as tax_class,
                    '.$ean_metakey_query.' as ean,
                
    			    -- weight, width, length, height
                    (select max(meta_value) from @DB_postmeta where post_id=IFNULL(pa.ID,p.ID) and meta_key=\'_weight\') as weight
                
                    '.($this->familyMatcher? '
                    ,0 as id_family' : '').'
                      
    			FROM
    			    @DB_posts p
                    left join `@DB_posts` pa on pa.post_parent=p.ID and pa.post_type=\'product_variation\' 
                    '.$ml_joins.'
                    -- inner join `@DB_term_relationships` tra on tra.object_id=p.ID and tra.term_taxonomy_id=11
    			WHERE p.post_type=\'product\' '.(empty($where_date)? '' : 'and '.$where_date).'
            ) as p
            '.$where.'
			ORDER BY p.id
		';
    }
    
    
    protected function row2dto($row)
    {
        $dto = parent::row2dto($row);
        if(empty($dto)) return $dto;
        
        $matcher = $this->matcher;
        $row_id = $row['id'];
        $product_id = $row['product_id'];
        
        if ($this->familyMatcher) {
            if ($this->familyLevel!==null) {
                $level = $this->familyLevel;
                $id_family = Fs2psTools::dbValue('
                    select min(c'.$level.'.term_id)
                    from @DB_term_taxonomy c0
                	inner join @DB_term_taxonomy c1 on c1.parent=c0.term_id
                    left join @DB_term_taxonomy c2 on c2.parent=c1.term_id
                    left join @DB_term_taxonomy c3 on c3.parent=c2.term_id
                    left join @DB_term_taxonomy c4 on c4.parent=c3.term_id
                    left join @DB_terms t on t.term_id=c'.$level.'.term_id
                    left join @DB_term_relationships tr on tr.term_taxonomy_id=c'.$level.'.term_taxonomy_id 
                    where c0.taxonomy=\'product_cat\' and c0.parent=0 and tr.object_id='.$product_id.'
                ');
            } else {
                $id_family = Fs2psTools::dbValue('
                    select min(c.term_id)
                    from @DB_term_relationships tr
                    inner join @DB_term_taxonomy c on c.term_taxonomy_id=tr.term_taxonomy_id and c.taxonomy=\'product_cat\'
                        inner join @DB_terms t on t.term_id=c.term_id
                        left join @DB_term_taxonomy cc on cc.parent=c.term_id
                        left join @DB_term_taxonomy pc on pc.term_id=c.parent -- and pc.is_root_category=0
                        where tr.object_id='.$product_id.' and cc.term_id is null
                ');
            }
            $dto['family'] = empty($id_family)? '' : $this->familyMatcher->dtoIdStrFromRowId($id_family);
        }
        
        $dto['pref'] = $matcher->referenceFromRowId($row_id);
        if (array_key_exists('pref',$dto) && $dto['pref']===null) unset($dto['pref']); // Evitamos dto['pref']==null

        if (!$this->download_description_short && isset($dto['descrip'])) unset($dto['descrip']);
        if (!$this->download_longdescrip && isset($dto['longdescrip'])) unset($dto['longdescrip']);
        
        return $dto;
    }
}

class Fs2psCombiasprodRefMatcher extends Fs2psDto2PostRefMatcher
{
    
    protected $gencombiref;
    protected $setref;
    protected $attributes_name_replacex;
    protected $attributes_name_patterns;
    
    public function __construct($task, $entity, $dto_id_fields)
    {
        $this->task = $task;
        parent::__construct($entity, $dto_id_fields, FALSE, FALSE, FALSE);
        $this->post_type = array('product', 'product_variation');
        $this->reloadCfg($task->cfg);
    }
    
    public function reloadCfg($cfg) {
        parent::reloadCfg($cfg);
        
        $download_catalog = $cfg->get('DOWNLOAD_CATALOG', '');
        $this->gencombiref = strpos($download_catalog, 'gencombiref') !== false;
        $this->forcegencombiref = strpos($download_catalog, 'forcegencombiref') !== false;
        $this->direct = strpos($download_catalog, 'direct') !== false;
        $this->persist = strpos($download_catalog, 'persist') !== false; # Se activa también para persistref
        //$this->persist = true; // Esto no funciona en Presta en Wordpress sí. Xq? Mejor no hacerlo o hacerlo sólo si se descargan sólo productos
        $this->setref = strpos($download_catalog, 'setref') !== false;
        $this->refsep = $cfg->get('DOWNLOAD_CATALOG_REFSEP', '_');
        
        $this->attributes_name_replacex = $cfg->get('IMATCH_ATTRIBUTES_NAME_REPLACEX', array());
        $this->attributes_name_patterns = $cfg->get('IMATCH_ATTRIBUTES_NAME_PATTERNS', array());
    }
    
    // Ignoramos _ como separador de $dto_id compuestos
    public function dtoIdToStr($dto_id) { return (string)$dto_id; }
    public function strToDtoId($str)  {
        if (empty($str) && $str!=='0') return null; // empty de string '0' se evalúa a true!!!??
        return $str;
    }
    
    public function deduceDtoIdStrFromName($name)
    {
        if (empty($name)) return null;
        foreach ($this->attributes_name_replacex as $search => $replacex) {
            $name = preg_replace($search, $replacex, $name);
        }
        if (empty($name)) return null;
        
        $matches = null;
        foreach ($this->attributes_name_patterns as $pattern) {
            preg_match($pattern, $name, $matches);
            if ($matches) {
                $dto_id = strtoupper(implode('', array_slice($matches, 1)));
                break;
            }
        }
        
        if (empty($dto_id)) {
            $msg = 'No se pudo deducir el dto_id para '.$name;
            throw new Fs2psException($msg);
        }
        
        return $dto_id;
    }
    
    protected function getPostTypeAndSku($post_id) {
        return Fs2psTools::dbRow('
			select p.post_type, pm.meta_value as sku
            from @DB_posts p
            left join @DB_postmeta pm on pm.post_id=p.ID and pm.meta_key=\'_sku\'
            where p.ID='.$post_id.' and p.post_type in (\'product\', \'product_variation\')
		');
    }
    
    protected $referenceByRowId = array();
    
    public function referenceFromRowId($row_id)
    {
        if (isset($this->referenceByRowId[$row_id])) return $this->referenceByRowId[$row_id];
        $ref = $this->_referenceFromRowId($row_id);
        $this->referenceByRowId[$row_id] = $ref;
        return $ref;
    }
    
    protected function _referenceFromRowId($row_id)
    {
        $post = $this->forcegencombiref? $this->getPostTypeAndSku($row_id) : null;
        
        if (!$this->forcegencombiref || $post['post_type']!='product_variation') {
            if (!$this->direct) {
                $dto_id = parent::_dtoIdStrFromRowId($row_id);
                if (!empty($dto_id)) return $dto_id; // if $this->direct $dto_id nunca será vacío y haremos siempre return aquí
            }
            
            if (empty($post)) $post = $this->getPostTypeAndSku($row_id);
            if (!$post) return null;
            if (!empty($post['sku'])) return $post['sku'];
        }
        
        if ($this->gencombiref && $post['post_type']=='product_variation') {
            $sku_suffix = Fs2psTools::dbValue('
    			SELECT GROUP_CONCAT(UPPER(pm.meta_value) ORDER BY meta_id DESC SEPARATOR \'||\')
                FROM @DB_postmeta pm
                WHERE pm.post_id='.$row_id.' and pm.meta_key like \'attribute_%\'
                GROUP BY pm.post_id
    		');
            if (!$sku_suffix) return null;
            
            $parent_sku = Fs2psTools::dbValue('
    			select pm.meta_value as sku
                from @DB_posts p
                left join @DB_postmeta pm on pm.post_id=p.post_parent and pm.meta_key=\'_sku\'
                where p.ID='.$row_id.' and p.post_type=\'product_variation\'
    		');
            if (!$parent_sku) return null;
            
            if (!empty($parent_sku) && !empty($sku_suffix)) {
                $names = preg_split("/\|\|/", $sku_suffix);
                $dto_id_parts = array($parent_sku);
                foreach ($names as $name) $dto_id_parts[] = $this->deduceDtoIdStrFromName($name);
                return implode($this->refsep, $dto_id_parts);
            }
        }
    }
    
    public function _oidStrFromRowId($row_id) {
        return $this->direct? $this->dtoIdToStr($row_id) : parent::_oidStrFromRowId($row_id);
    }
    
    public function _dtoIdStrFromRowId($row_id)
    {
        if ($this->direct) {
            $dto_id = parent::_dtoIdStrFromRowId($row_id);
            if (!empty($dto_id)) return $dto_id; // if $this->direct $dto_id nunca será vacío y haremos siempre return aquí
        }
        
        return $this->referenceFromRowId($row_id);
    }
    
    public function updateReverseMatch($dto_id, $row_id)
    {
        parent::updateReverseMatch($dto_id, $row_id); // TODO cfillol: La naturaleza dto/row es distinta. ¿Quitar?
        if ($this->setref) {
            $ref = $this->referenceFromRowId($row_id);
            if (Fs2psTools::dbValue('select count(1) from @DB_postmeta where meta_key=\'_sku\' and post_id='.$row_id)) {
                Fs2psTools::dbUpdate('postmeta', array('meta_value'=>$ref), array('post_id'=>$row_id, 'meta_key'=>'_sku'));
            } else {
                Fs2psTools::dbInsert('postmeta', array('meta_value'=>$ref, 'post_id'=>$row_id, 'meta_key'=>'_sku'));
            }
        }
    }
    
}
