{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 *}
{extends file='customer/page.tpl'}

{block name='page_title'}
  Facturas
{/block}

{block name='page_content'}


    <form method="post" action="{$link->getModuleLink('fs2psinvoices', 'invoices')}">
      <select style="width:200px;display:inline;" class="form-control form-control-select" name="fec-fil">
        {foreach from=$dates item="label" key="value"}
          <option value="{$value}" {if $value eq $selected_value} selected {/if}>{$label}</option>
        {/foreach}
      </select>
      <input style="display:inline;width:80px;" class="form-control" type="submit" value="Filtrar"/>
    </form>
    
  {if $orders}
    <table class="table table-striped table-bordered table-labeled hidden-xs-down">
      <thead class="thead-default">
        <tr>
          <th style="width:10%;">ID pedido</th>
          <th style="width:20%;">Referencia</th>
          <th style="width:30%;">Fecha de Actualización</th>
          <th style="width:30%;">Fecha de Facturación</th>
          <th style="width:10%;">Facturas</th>
        </tr>
      </thead>
      <tbody>
        {foreach from=$orders item=order}
          <tr>
            <th scope="row">{$order.id_order}</th>
            <td>{$order.reference}</td>
            <td>{$order.last_update}</td>
            <td>{$order.idate}</td>
            <td>
            <a style="display: inline-block; margin: 5px; text-align:center;" href="?fc=module&amp;module=fs2psinvoices&amp;controller=pdf&amp;invoice={$order.id}" target="_blank" download>
                 <i  class="material-icons">
                   <svg style="margin:2px;max-height:20px;" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path fill="currentColor" d="M288 248v28c0 6.6-5.4 12-12 12H108c-6.6 0-12-5.4-12-12v-28c0-6.6 5.4-12 12-12h168c6.6 0 12 5.4 12 12zm-12 72H108c-6.6 0-12 5.4-12 12v28c0 6.6 5.4 12 12 12h168c6.6 0 12-5.4 12-12v-28c0-6.6-5.4-12-12-12zm108-188.1V464c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V48C0 21.5 21.5 0 48 0h204.1C264.8 0 277 5.1 286 14.1L369.9 98c9 8.9 14.1 21.2 14.1 33.9zm-128-80V128h76.1L256 51.9zM336 464V176H232c-13.3 0-24-10.7-24-24V48H48v416h288z"></path></svg>
                 </i>
                <span style="display:block; margin-top: 2px; line-height: 1em; font-size: 16px; font-weight: bold;">{$order.num}</span>
            </a>
            </td>
          </tr>
        {/foreach}
      </tbody>
    </table>
    
    <table style="font-size:10px" class="table table-striped table-bordered table-labeled hidden-sm-up">
      <thead class="thead-default">
        <tr>
          <th style="width:10%;">ID pedido</th>
          <th style="width:20%;">Referencia</th>
          <th style="width:30%;">Fecha de Actualización</th>
          <th style="width:30%;">Fecha de Facturación</th>
          <th style="width:10%;">Facturas</th>
        </tr>
      </thead>
      <tbody>
        {foreach from=$orders item=order}
          <tr>
            <th scope="row">{$order.id_order}</th>
            <td>{$order.reference}</td>
            <td>{$order.last_update}</td>
            <td>{$order.idate}</td>
            <td>
            <a class="download_button" style="display: inline-block; margin: 5px; text-align:center;" href="?fc=module&amp;module=fs2psinvoices&amp;controller=pdf&amp;invoice={$order.id}" target="_blank" download>
                <i  class="material-icons">
                  <svg style="margin:2px;max-height:20px;" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path fill="currentColor" d="M288 248v28c0 6.6-5.4 12-12 12H108c-6.6 0-12-5.4-12-12v-28c0-6.6 5.4-12 12-12h168c6.6 0 12 5.4 12 12zm-12 72H108c-6.6 0-12 5.4-12 12v28c0 6.6 5.4 12 12 12h168c6.6 0 12-5.4 12-12v-28c0-6.6-5.4-12-12-12zm108-188.1V464c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V48C0 21.5 21.5 0 48 0h204.1C264.8 0 277 5.1 286 14.1L369.9 98c9 8.9 14.1 21.2 14.1 33.9zm-128-80V128h76.1L256 51.9zM336 464V176H232c-13.3 0-24-10.7-24-24V48H48v416h288z"></path></svg>
                </i>
                <span style="display:block; margin-top: 2px; line-height: 1em; font-size: 16px; font-weight: bold;">{$order.num}</span>
            </a>
            </td>
          </tr>
        {/foreach}
      </tbody>
    </table>
  {else}
  	<p class="mt-2 mb-2">
       Aún no se facturo ningún pedido. Póngase en contacto con nosotros si necesita disponer de factura.
   	</p>
  {/if}
{/block}
