<?php

include_once(_PS_MODULE_DIR_.'fs2ps/Fs2psTools.php');
include_once(dirname(__FILE__).'/../../Fs2psMyInvoice.php');

class AdminFs2psInvoicesOrderController  extends AdminController
{
    public $toolbar_title;
    
    protected $statuses_array = array();
    
    public function __construct()
    {
        $this->bootstrap = true;
        $this->table = 'order';
        $this->className = 'Order';
        $this->lang = false;
        $this->addRowAction('view');
        $this->explicitSelect = true;
        $this->allow_export = false;
        $this->deleted = false;
        $this->context = Context::getContext();
        
        $this->toolbar_title = 'Pedidos y facturas vinculadas';
        
        $this->_select = '
		a.id_currency,
        a.id_order AS id_pdf,
		CONCAT(LEFT(c.`firstname`, 1), \'. \', c.`lastname`) AS `customer`,
		osl.`name` AS `osname`,
		os.`color`,
		IF((SELECT COUNT(so.id_order) FROM `'._DB_PREFIX_.'orders` so WHERE so.id_customer = a.id_customer) > 1, 0, 1) as new,
		country_lang.name as cname,
		IF(a.valid, 1, 0) badge_success';
        
        $this->_join = '
		LEFT JOIN `'._DB_PREFIX_.'customer` c ON (c.`id_customer` = a.`id_customer`)
		INNER JOIN `'._DB_PREFIX_.'address` address ON address.id_address = a.id_address_delivery
		INNER JOIN `'._DB_PREFIX_.'country` country ON address.id_country = country.id_country
		INNER JOIN `'._DB_PREFIX_.'country_lang` country_lang ON (country.`id_country` = country_lang.`id_country` AND country_lang.`id_lang` = '.(int)$this->context->language->id.')
		LEFT JOIN `'._DB_PREFIX_.'order_state` os ON (os.`id_order_state` = a.`current_state`)
		LEFT JOIN `'._DB_PREFIX_.'order_state_lang` osl ON (os.`id_order_state` = osl.`id_order_state` AND osl.`id_lang` = '.(int)$this->context->language->id.')
        LEFT JOIN `'._DB_PREFIX_.'fs2ps_order_invoice_summary` ois ON (ois.`order`=a.`id_order`)';
        $this->_orderBy = 'id_order';
        $this->_orderWay = 'DESC';
        
        /*
        $statuses = OrderState::getOrderStates((int)$this->context->language->id);
        foreach ($statuses as $status) {
            $this->statuses_array[$status['id_order_state']] = $status['name'];
        }
        */
        
        $this->fields_list = array(
            'id_order' => array(
                'title' => 'ID', //$this->l('ID'),
                'align' => 'text-center',
                'class' => 'fixed-width-xs'
            ),
            'reference' => array(
                'title' => 'Referencia', //$this->l('Reference')
            ),
            /*
            'new' => array(
                'title' => $this->l('New client'),
                'align' => 'text-center',
                'type' => 'bool',
                'tmpTableFilter' => true,
                'orderby' => false
            ),
            */
            'customer' => array(
                'title' => 'Cliente', //$this->l('Customer'),
                'havingFilter' => true,
            ),
        );
        
        if (Configuration::get('PS_B2B_ENABLE'))
        {
            $this->fields_list = array_merge($this->fields_list, array(
                'company' => array(
                    'title' => 'Empresa', //$this->l('Company'),
                    'filter_key' => 'c!company'
                ),
            ));
        }
        
        $this->fields_list = array_merge($this->fields_list, array(
            'total_paid_tax_incl' => array(
                'title' => 'Total', //$this->l('Total'),
                'align' => 'text-right',
                'type' => 'price',
                'currency' => true,
                'callback' => 'setOrderCurrency',
                'badge_success' => true
            ),
            /*
            'payment' => array(
                'title' => $this->l('Payment')
            ),
            'osname' => array(
                'title' => $this->l('Status'),
                'type' => 'select',
                'color' => 'color',
                'list' => $this->statuses_array,
                'filter_key' => 'os!id_order_state',
                'filter_type' => 'int',
                'order_key' => 'osname'
            ),
            */
            'date_add' => array(
                'title' => 'Fecha', //$this->l('Date'),
                'align' => 'text-right',
                'type' => 'datetime',
                'filter_key' => 'a!date_add'
            ),
            'emailed' => array(
                'title' => 'Enviada',
                'align' => 'text-right',
                'type' => 'datetime',
                'filter_key' => 'ois!emailed'
            ),
            'id_pdf' => array(
                'title' => 'Facturas', // $this->l('Invoices'),
                'align' => 'text-center',
                'callback' => 'printPDFIcons',
                'orderby' => false,
                'search' => false,
                'remove_onclick' => true
            )
        ));
        
        $this->bulk_actions = array();
        /*
        $this->bulk_actions = array(
            'updateOrderStatus' => array('text' => $this->l('Change Order Status'), 'icon' => 'icon-refresh')
        );
        */
        $this->list_no_link = true;
        
        parent::__construct();
        
    }
    
    
    /**
     * Create a template from the override file, else from the base file.
     *
     * @param string $tpl_name filename
     * @return Template
     */
    public function createCustomTemplate($tpl_name)
    {
        $tplFolder = dirname(__FILE__).'/../../views/templates/admin/orders/';
        return $this->context->smarty->createTemplate($tplFolder.$tpl_name, $this->context->smarty);
    }
    
    public static function setOrderCurrency($echo, $tr)
    {
        $order = new Order($tr['id_order']);
        return Tools::displayPrice($echo, (int)$order->id_currency);
    }
    
    public function initPageHeaderToolbar()
    {
         parent::initPageHeaderToolbar();
    }
     
    public function initToolbar() 
    {
        parent::initToolbar();
        unset( $this->toolbar_btn['new'] );
        unset( $this->toolbar_btn['export'] );
    }
    
    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        
        $this->addJqueryUI('ui.datepicker');
        $this->addJS(_PS_JS_DIR_.'vendor/d3.v3.min.js');
        //$this->addJS('https://maps.googleapis.com/maps/api/js?v=3.exp&sensor=false');
        
        // if ($this->tabAccess['edit'] == 1 && $this->display == 'view')
        // {
        //     $this->addJS(_PS_JS_DIR_.'admin_order.js');
        //     $this->addJS(_PS_JS_DIR_.'tools.js');
        //     $this->addJqueryPlugin('autocomplete');
        // }
    }
    
    public function printPDFIcons($id_order, $tr)
    {
        $invoices = Fs2psTools::dbSelect('
            select i.id, i.num, i.year
            from @DB_fs2ps_order_invoice oi
            inner join @DB_fs2ps_invoice i on i.id=oi.invoice
            where oi.order='.$id_order.'
        ');
        $this->context->smarty->assign(array('invoices' => $invoices));
        return $this->createCustomTemplate('invoices_pdf_icon.tpl')->fetch();
    }
    
    public function renderList()
    {
        $this->actions = array();
        $this->addRowAction('enviarfacturas');
        $this->addRowAction('borrarfacturas');
        //$this->addRowAction('anadirfactura');
        return parent::renderList();
    }
    
    public function displayEnviarfacturasLink($token = null, $id, $name = null)
    {
        if (Fs2psMyInvoice::orderHasInvoices($id)) {
            $tpl = $this->createCustomTemplate('list_action_enviarfacturas.tpl');
            $tpl->assign(array(
                'href' => self::$currentIndex.'&'.$this->identifier.'='.$id.'&ajax=1&action=sendOrderInvoicesByEmail'.'&token='.($token != null ? $token : $this->token),
                'action' => 'Enviar facturas',
                'class' => 'enviar-facturas-opt',
                'icon' => 'envelope',
                'id' => $id
            ));
            return $tpl->fetch();
        }
    }
    
    public function displayAnadirFacturaLink($token = null, $id, $name = null)
    {
        $tpl = $this->createCustomTemplate('list_action.tpl');
        $tpl->assign(array(
            'href' => self::$currentIndex.'&'.$this->identifier.'='.$id.'&anadirfactura'.$this->table.'&token='.($token != null ? $token : $this->token),
            'action' => 'Añadir factura',
            'class' => 'anadir-factura-opt',
            'icon' => 'plus',
            'id' => $id
        ));
        return $tpl->fetch();
    }
    
    public function displayBorrarfacturasLink($token = null, $id, $name = null)
    {
        if (Fs2psMyInvoice::orderHasInvoices($id)) {
            $tpl = $this->createCustomTemplate('list_action_borrarfacturas.tpl');
            $tpl->assign(array(
                'href' => self::$currentIndex.'&'.$this->identifier.'='.$id.'&ajax=1&action=deleteOrderInvoices'.'&token='.($token != null ? $token : $this->token),
                'action' => 'Borrar facturas',
                'icon' => 'trash',
                'id' => $id
            ));
            return $tpl->fetch();
        }
    }
    
    public function postProcess()
    {
        if (Tools::isSubmit('generateInvoicePDF') && Tools::getValue('invoice')) {
            $id_invoice = (int)Tools::getValue('invoice');
            $invoice = new Fs2psMyInvoice($id_invoice);
            $invoice->returnPdfToBrowser();
        }
        parent::postProcess();
    }
    
    public function ajaxProcessDeleteOrderInvoices()
    {
        Fs2psMyInvoice::deleteOrderInvoices((int)Tools::getValue('id_order'));
    }
    
    public function ajaxProcessSendOrderInvoicesByEmail()
    {
        if(Fs2psMyInvoice::sendOrderInvoicesByEmail((int)Tools::getValue('id_order'))) {
            die(Tools::jsonEncode(array(
                'emailed' => Fs2psTools::now(),
            )));
        }
    }
    
}
