<?php
/**
* LICENCIA
*
* Este programa se propociona "tal cual", sin garantía de ningún tipo más allá del soporte
* pactado a la hora de adquirir el programa.
*
* En ningún caso los autores o titulares del copyright serán responsables de ninguna
* reclamación, daños u otras responsabilidades, ya sea en un litigio, agravio o de otro
* modo, que surja de o en conexión con el programa o el uso u otro tipo de acciones
* realizadas con el programa.
*
* Este programa no puede modificarse ni distribuirse sin el consentimiento expreso del autor.
*
*    @author    Carlos Fillol Sendra <festeweb@festeweb.com>
*    @copyright 2014 Fes-te web! - www.festeweb.com
*    @license   http://www.festeweb.com/static/licenses/fs2ps_1.1.0.txt
*/

include_once(_PS_MODULE_DIR_.'fs2ps/Fs2psTask.php');
include_once(_PS_MODULE_DIR_.'fs2ps/Fs2psObjectModels.php');
include_once(dirname(__FILE__).'/Fs2psMyInvoice.php');

class Fs2psUploadInvoicesPdfsTask extends Fs2psTask
{
    public function __construct($mng, $cmd)
    {
        parent::__construct('upload_invoices_pdfs', $mng, $cmd);
    }
    
    protected function _execute($cmd)
    {
        if (empty($cmd['invoices_pdfs'])) return;
        foreach ($cmd['invoices_pdfs'] as $dto)
        {
            if (empty($dto['order'])) continue;
            $order = new Fs2psOrder($dto['order']);
            if (empty($order->reference)) continue;
            
            $num = $dto['num'];
            $year = empty($dto['year'])? null : $dto['year'];
            $invoice = Fs2psMyInvoice::findByNum($num, $year, $order->id);
            if (!$invoice) {
                $invoice = new Fs2psMyInvoice();
                $invoice->num = $num;
                $invoice->year = $year;
                $invoice->name = $dto['name'];
                $invoice->idate = $dto['idata'];
                $invoice->save();
                if (empty($invoice->id)) {
                    throw new Fs2psException('No se pudo crear la factura. Reinicialice el modulo fs2psinvoices en la web.');
                }
            } else {
                if ($invoice->year!=$year) $invoice->deletePdf(); // Borramos pdf de ubicación actual si cambia el anyo
                
                $invoice->name = $dto['name'];
                $invoice->year = $year;
                $invoice->idate = $dto['idata'];
                $invoice->update();
            }
            
            $changed = $invoice->saveDataAsPdf($dto['data']);
            $added = $invoice->addToOrder($dto['order'], $changed);
            
            $invoices_send_email = $this->cfg->get('INVOICES_SEND_EMAIL');
            $nosend = empty($invoices_send_email) || strtolower($invoices_send_email)==='false';
            $send = !$nosend && ($added || $invoices_send_email!=='ifchanged');
            if ($send) {
                Fs2psMyInvoice::sendOrderInvoicesByEmail($dto['order']);
            }
        }
    }
    
}
