<?php
/**
 * LICENCIA
 *
 * Este programa se propociona "tal cual", sin garantía de ningún tipo más allá del soporte
 * pactado a la hora de adquirir el programa.
 *
 * En ningún caso los autores o titulares del copyright serán responsables de ninguna
 * reclamación, daños u otras responsabilidades, ya sea en un litigio, agravio o de otro
 * modo, que surja de o en conexión con el programa o el uso u otro tipo de acciones
 * realizadas con el programa.
 *
 * Este programa no puede modificarse ni distribuirse sin el consentimiento expreso del autor.
 *
 *    @author    Carlos Fillol Sendra <festeweb@festeweb.com>
 *    @copyright 2014 Fes-te web! - www.festeweb.com
 *    @license   http://www.festeweb.com/static/licenses/fs2psinvoices_1.1.0.txt
 */

if (!defined('_CAN_LOAD_FILES_')) exit;

include_once(_PS_MODULE_DIR_.'fs2ps/Fs2psTools.php');

class fs2psinvoices extends Module
{
    const MIN_VER = '1.5.0.0';
    const MAX_VER = '9.9.999.999';
    
    private $hooks = [
        'orderDetailDisplayed',
        'displayCustomerAccount'
    ];
    
    public function __construct()
    {
        $this->name = 'fs2psinvoices';
        $this->tab = 'migration_tools';
        $this->version = '2.19.2';
        $this->author = 'Fes-te web!';
        $this->need_instance = 0;
        $this->bootstrap = true;
        
        $this->ps_versions_compliancy = array('min' => self::MIN_VER, 'max' => self::MAX_VER);
        if (version_compare(_PS_VERSION_, self::MIN_VER) < 0 ||
            version_compare(_PS_VERSION_, self::MAX_VER) > 0)
        {
            // Avoid problems with PS before 1.5
            $this->_errors[] = $this->l('The version of your module is not compliant with your PrestaShop version.');
            return false;
        }
        
        parent::__construct();
        
        $this->displayName = 'fs2psinvoices';
        $this->description = 'Módulo para compartir con los clientes las facturas generadas en FactuSOL a través de Prestashop';
        $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');
        
        if (!Configuration::get('FS2PS_KEY')) {
            $this->warning = 'Debes tener instalado y configurado el módulo de FS2PS para que FS2PS INVOICES funcione.';
        }
    }
    
    public function install()
    {
        // Este modulo depende del módulo fs2ps
        if (!file_exists(_PS_MODULE_DIR_.'fs2ps') || !parent::install()) return false;
        foreach ($this->hooks as $hook){
            if (!$this->registerHook($hook)) return false;
        }
        
        $upgrate_versions = array('2.8.1', '2.9.26', '2.9.200');
        foreach ($upgrate_versions as $ver)
        {
            include(dirname(__FILE__).'/upgrade/install-'.$ver.'.php');
            $upgrade_func = 'upgrade_module_'.str_replace('.', '_', $ver);
            
            if (!$upgrade_func($this))
                return false;
        }
        
        $this->createAdminTabs();
        
        return true;
    }
    
    public function uninstall()
    {
        
        if (!parent::uninstall()) return false;
        foreach ($this->hooks as $hook) {
            if (!$this->unregisterHook($hook)) return false;
        }
        $this->removeAdminTabs();
        
        return true;
    }
    
    protected function createAdminTabs()
    {
        $languages = Language::getLanguages(false);
        
        if (!$id_tab = (int)Tab::getIdFromClassName('AdminFs2ps')) {
            $parentTab = new Tab();
            $parentTab->active = 1;
            $parentTab->name = array();
            $parentTab->class_name = "AdminFs2ps";
            foreach ($languages as $language) {
                $parentTab->name[$language['id_lang']] = 'FS2PS';
            }
            $parentTab->id_parent = 0;
            $parentTab->module = '';
            $parentTab->add();
        }
        if (!(int) Tab::getIdFromClassName('AdminFs2psInvoicesOrder')) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = "AdminFs2psInvoicesOrder";
            $tab->name = array();
            foreach ($languages as $language) {
                $tab->name[$language['id_lang']] = $this->l('Facturas FS2PS');
            }
            $tab->id_parent = Tab::getIdFromClassName('AdminFs2ps');
            $tab->module = $this->name;
            $tab->add();
        } else {
            $tab = new Tab((int) $id_tab);
        }
        
    }
    
    protected function removeAdminTabs()
    {
        if ($id_tab = Tab::getIdFromClassName('AdminFs2psInvoicesOrder')) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }
    }
    
    public function hookOrderDetailDisplayed($params)
    {
        $id_order = intval($params['order']->id);
        $invoices = Fs2psTools::dbSelect('
            select i.id, i.num, i.year, i.name
            from @DB_fs2ps_order_invoice oi
            inner join @DB_fs2ps_invoice i on i.id=oi.invoice
            where oi.order='.$id_order.'
        ');
        $this->context->smarty->assign(
            array(
                'invoices' => $invoices,
                'base_dir' => $this->context->shop->getBaseURL(true), // TODO: funciona en PS 1.6 y PS 1.7?
            )
        );
        if (version_compare(_PS_VERSION_, '1.7.0.0') < 0) {
            return $this->display(__FILE__, 'views/templates/hook/orderdetaildisplayed_Pre16.tpl');
        } else {
            return $this->display(__FILE__, 'views/templates/hook/orderdetaildisplayed_Pre17.tpl');
        }
    }
    
    
    public function hookDisplayCustomerAccount()
    {
        if (version_compare(_PS_VERSION_, '1.7.0.0') < 0) {
            return $this->display(__FILE__, 'views/templates/hook/displayCustomerAccountInvoices_Pre16.tpl');
        } else {
            return $this->display(__FILE__, 'views/templates/hook/displayCustomerAccountInvoices_Pre17.tpl');
        }
    }
    
}