{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 *}

{capture name=path}
	<a href="{$link->getPageLink('my-account', true)|escape:'html'}" title="Mi cuenta">Mi cuenta</a><span class="navigation-pipe">{$navigationPipe}</span>Facturas
{/capture}

{block name='page_title'}
  Facturas
{/block}

{block name='page_content'}
	<form style="margin-bottom:10px" method="post" action="{$link->getModuleLink('fs2psinvoices', 'invoices')}">
	  <div style="display: inline-block; vertical-align: middle;width:200px">
      <select class="form-control" name="fec-fil" {if $dates.required}required{/if}>
        {foreach from=$dates item="label" key="value"}
          <option value="{$value}" {if $value eq $selected_value} selected {/if}>{$label}</option>
        {/foreach}
      </select>
      </div>
      <input style="display: inline-block; width: 80px;" class="form-control" type="submit" value="Filtrar"/>
    </form>

  {if $orders}
  	<div class="hidden-xs hidden-sm">
        <table class="table table-striped table-bordered table-labeled">
          <thead class="thead-default">
            <tr>
              <th style="width:10%;">ID pedido</th>
              <th style="width:20%;">Referencia</th>
              <th style="width:30%;">Fecha de Actualización</th>
              <th style="width:30%;">Fecha de Facturación</th>
              <th style="width:10%;">Facturas</th>
            </tr>
          </thead>
          <tbody>
            {foreach from=$orders item=order}
              <tr>
                <th scope="row">{$order.id_order}</th>
                <td>{$order.reference}</td>
                <td>{$order.last_update}</td>
                <td>{$order.idate}</td>
                <td>
                <a style="display: inline-block; margin: 5px; text-align:center;" target="_blank" href="{$base_dir}?fc=module&amp;module=fs2psinvoices&amp;controller=pdf&amp;invoice={$order.id}">
                    <i style="font-size: 20px;" class="icon-file-text"></i>
                    <span style="display:block; margin-top: 2px; line-height: 1em; font-size: 16px; font-weight: bold;">{$order.num}</span>
                </a>
                </td>
              </tr>
            {/foreach}
          </tbody>
        </table>
    </div>
    
    <div style="font-size:10px" class="hidden-md hidden-lg">
        <table class="table table-striped table-bordered table-labeled">
          <thead class="thead-default">
            <tr>
              <th style="width:10%;">ID pedido</th>
              <th style="width:20%;">Referencia</th>
              <th style="width:30%;">Fecha de Actualización</th>
              <th style="width:30%;">Fecha de Facturación</th>
              <th style="width:10%;">Facturas</th>
            </tr>
          </thead>
          <tbody>
            {foreach from=$orders item=order}
              <tr>
                <th scope="row">{$order.id_order}</th>
                <td>{$order.reference}</td>
                <td>{$order.last_update}</td>
                <td>{$order.idate}</td>
                <td>
                <a style="display: inline-block; margin: 5px; text-align:center;" target="_blank" href="{$base_dir}?fc=module&amp;module=fs2psinvoices&amp;controller=pdf&amp;invoice={$order.id}">
                    <i style="font-size: 15px;" class="icon-file-text"></i>
                    <span style="display:block; margin-top: 2px; line-height: 1em; font-size: 16px; font-weight: bold;">{$order.num}</span>
                </a>
                </td>
              </tr>
            {/foreach}
          </tbody>
        </table>
    </div>
  {else}
  	<p style="margin-top: 10px;margin-bottom: 10px;">
       Aún no se facturo ningún pedido. Póngase en contacto con nosotros si necesita disponer de factura.
   	</p>
  {/if}
{/block}
