<?php
/**
* LICENCIA
*
* Este programa se propociona "tal cual", sin garantía de ningún tipo más allá del soporte
* pactado a la hora de adquirir el programa.
*
* En ningún caso los autores o titulares del copyright serán responsables de ninguna
* reclamación, daños u otras responsabilidades, ya sea en un litigio, agravio o de otro
* modo, que surja de o en conexión con el programa o el uso u otro tipo de acciones
* realizadas con el programa.
*
* Este programa no puede modificarse ni distribuirse sin el consentimiento expreso del autor.
*
*    @author    Carlos Fillol Sendra <festeweb@festeweb.com>
*    @copyright 2014 Fes-te web! - www.festeweb.com
*    @license   http://www.festeweb.com/static/licenses/fs2ps_1.1.0.txt
*/

if (!defined('_PS_VERSION_'))
	exit;


function upgrade_module_2_8_1($object)
{
	
	try
	{
	    
	    Fs2psTools::dbExec('
			CREATE TABLE `@DB_fs2ps_invoice` (
			`id` int(10) unsigned auto_increment,
			`num` varchar(255),
			`name` varchar(255),
			PRIMARY KEY (`id`))
			ENGINE=@ENG DEFAULT CHARSET=utf8
		');
	    
	    Fs2psTools::dbExec('
			CREATE TABLE `@DB_fs2ps_order_invoice` (
			`order` int(10) unsigned auto_increment,
			`invoice` int(10) unsigned,
			PRIMARY KEY (`order`,`invoice`))
			ENGINE=@ENG DEFAULT CHARSET=utf8
		');
	    
	    Fs2psTools::dbExec('
			ALTER TABLE `@DB_fs2ps_invoice`
			ADD UNIQUE INDEX `invoice_num` (`num`)
		');
	    
	}
	catch (Exception $e)
	{
	    Logger::addLog('fs2ps upgrade 2.8.1: '.Fs2psTools::dbEscape($e->getMessage()), 1);
	}
	
	try
	{
	    Fs2psTools::dbExec('
			CREATE TABLE `@DB_fs2ps_order_invoice_summary` (
			`order` int(10) unsigned,
            `updated` datetime,
            `emailed` datetime,
			PRIMARY KEY (`order`))
			ENGINE=@ENG DEFAULT CHARSET=utf8
		');
	    
	    Fs2psTools::dbExec('
			ALTER TABLE `@DB_fs2ps_order_invoice_summary`
			ADD INDEX `updated` (`updated`)
		');
	    
	    Fs2psTools::dbExec('
			ALTER TABLE `@DB_fs2ps_order_invoice_summary`
			ADD INDEX `emailed` (`emailed`)
		');
	    
	}
	catch (Exception $e)
	{
		Logger::addLog('fs2ps upgrade 2.8.1: '.Fs2psTools::dbEscape($e->getMessage()), 1);
	}
	
	return true;
}
