<?php
/**
* LICENCIA
*
* Este programa se propociona "tal cual", sin garantía de ningún tipo más allá del soporte
* pactado a la hora de adquirir el programa.
*
* En ningún caso los autores o titulares del copyright serán responsables de ninguna
* reclamación, daños u otras responsabilidades, ya sea en un litigio, agravio o de otro
* modo, que surja de o en conexión con el programa o el uso u otro tipo de acciones
* realizadas con el programa.
*
* Este programa no puede modificarse ni distribuirse sin el consentimiento expreso del autor.
*
*    @author    Carlos Fillol Sendra <festeweb@festeweb.com>
*    @copyright 2014 Fes-te web! - www.festeweb.com
*    @license   http://www.festeweb.com/static/licenses/fs2ps_1.1.0.txt
*/

include_once(dirname(__FILE__).'/../../Fs2psMyInvoice.php');

class Fs2psInvoicesPdfModuleFrontController extends ModuleFrontController
{

	public function __construct()
	{
		parent::__construct();
		$this->context = Context::getContext();
	}

	 /* http://www.mirsen.desa/?fc=module&module=fs2psinvoices&controller=pdf&invoice=2 */
	public function initContent()
	{
	    $http_error_code = 500;
		$error = null;
		$response = null;

		try
		{
		    
		    $id_invoice = (int)Tools::getValue('invoice');
		    
		    if (!Validate::isUnsignedId($id_invoice)) {
		        $http_error_code = 400;
		        throw new Exception('No se indicó el identificador de la factura');
		    }
		        
		    $invoice = new Fs2psMyInvoice($id_invoice);
		    if (empty($invoice->num)) {
		        $http_error_code = 404;
		        throw new Exception('La factura indicada no existe');
		    }
		    
		    if (!$this->context->customer->isLogged()) {
		        $http_error_code = 401;
		        throw new Exception('Debe autentificarse para poder descargar facturas');
		    }
		    
		    if (!$invoice->customerCanViewInvoice($this->context->customer->id, $id_invoice)) {
		        $http_error_code = 403;
		        throw new Exception('No tiene permiso para ver esta factura');
		    }
		    
		    $invoice->returnPdfToBrowser();
		    
		}
		catch (Exception $e)
		{
		    $error = $e->getMessage();
		    http_response_code($http_error_code);
		}

		// Finally
		if ($error)
			die($error);

		if ($response)
			die($response);

	}

}
