<?php
/**
 * 2007-2018 PrestaShop
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2018 PrestaShop SA
 * @license   http://addons.prestashop.com/en/content/12-terms-and-conditions-of-use
 * International Registered Trademark & Property of PrestaShop SA
 */

class fs2psinvoicesinvoicesModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        $smarty = $this->context->smarty;
        
        $this->display_column_right = false;
        $this->display_column_left = false;
        
        $context = Context::getContext();
        if (empty($context->customer->id)) {
            Tools::redirect('index.php');
        }
        
        parent::initContent();
        
        $filter = filter_input(INPUT_POST, 'fec-fil', FILTER_SANITIZE_STRING);
        
        $dates = ['last_four_month' => 'Últimos 4 meses',];
        for ($i = 0; $i < 5; $i++) {
            $date = date('Y')-$i;
            $dates['year_'.$date] = $date;
        }
        $dates['all'] = 'Todas';
        
        $orders = $this->getInvoices(empty($filter)?'last_four_month':$filter);
        
        $smarty->assign([
            'orders' => $orders,
            'dates' => $dates,
            'selected_value' => empty($filter)? 'last_four_month' : $filter,
        ]);
        
        if (version_compare(_PS_VERSION_, '1.7.0.0') > 0) // PrestaShop +1.7.0.0
            $this->setTemplate('module:fs2psinvoices/views/templates/front/invoices_pre_17.tpl');
        else
            $this->setTemplate('invoices_pre_16.tpl');
    }
    
    public function getInvoices($filter) 
    {        
        
        if ($filter !== 'all') {
            if (substr($filter, 0, 5) === 'year_') {
                $year = intval(substr($filter, 5));
                $where_case = '(idate is not null and YEAR(idate)='.$year.') or (idate is null and YEAR(ois.updated)='.$year.')';
            }
            elseif ($filter === 'last_four_month') 
                $where_case = '(idate is not null and idate >= now() - interval 4 month) or (idate is null and ois.updated >= now() - interval 4 month)';
        }
            
        $orders = $this->find(!empty($where_case)?'and ('.$where_case.')':'');
        
        foreach ($orders as &$order)
        {
            $updated = DateTime::createFromFormat('Y-m-d H:i:s', $order['last_update']);
            $order['last_update'] = date_format($updated, 'd-m-Y');
            
            $updated = DateTime::createFromFormat('Y-m-d', $order['idate']);
            $order['idate'] = date_format($updated, 'd-m-Y');
        }
        return $orders;
    }
    
    
    public function find($where_case='')
    {
        $this->context = Context::getContext() ;
        $id_customer = $this->context->customer->id;
        
        return Fs2psTools::dbSelect('
                SELECT o.id_order,
                	   o.reference,
                       ois.updated as last_update,
                	   i.num,
                	   i.id,
                       i.idate
                FROM `@DB_orders` o
                	inner join `@DB_fs2ps_order_invoice` oi on oi.order=o.id_order
                	inner join `@DB_fs2ps_invoice` i on i.id=oi.invoice
                    inner join `@DB_fs2ps_order_invoice_summary` ois on ois.order=o.id_order
                WHERE
                    o.id_customer='.((int)$id_customer).' '.$where_case.'
                ORDER BY i.idate DESC, o.id_order ASC
            ');
    }

    /* Para PS 1.7 */
    public function getBreadcrumbLinks()
    {
        $breadcrumb = parent::getBreadcrumbLinks();
        
        $breadcrumb['links'][] = $this->addMyAccountToBreadcrumb();
        $breadcrumb['links'][] = [
            'title' => $this->getTranslator()->trans('Facturas', [], 'Shop.Theme.Global'),
            'url' => '',
        ];
        
        return $breadcrumb;
    }
    
    /** # AJAX
    public function setMedia()
    {
        parent::setMedia();
        
        $path_uri = $this->module->getPathUri();
        $js_path = $path_uri.'/views/js/';
        $css_path = $path_uri.'/views/css/';
        
        $controller = $this->context->controller;
        $controller->addJS($js_path.'fwb2bhis.js');
        $controller->addCSS($css_path.'fwb2bhis.css');
    }
    */
}
