<?php
/**
* LICENCIA
*
* Este programa se propociona "tal cual", sin garantía de ningún tipo más allá del soporte
* pactado a la hora de adquirir el programa.
*
* En ningún caso los autores o titulares del copyright serán responsables de ninguna
* reclamación, daños u otras responsabilidades, ya sea en un litigio, agravio o de otro
* modo, que surja de o en conexión con el programa o el uso u otro tipo de acciones
* realizadas con el programa.
*
* Este programa no puede modificarse ni distribuirse sin el consentimiento expreso del autor.
*
*    @author    Carlos Fillol Sendra <festeweb@festeweb.com>
*    @copyright 2014 Fes-te web! - www.festeweb.com
*    @license   http://www.festeweb.com/static/licenses/fs2ps_1.1.0.txt
*/

include_once(_PS_MODULE_DIR_.'fs2ps/Fs2psException.php');
include_once(_PS_MODULE_DIR_.'fs2ps/Fs2psTools.php');

class Fs2psMyInvoice extends ObjectModel
{
	public $id;
	public $num;
	public $year;
	public $name;
	public $idate;

	public static $definition = array(
		'table' => 'fs2ps_invoice',
		'primary' => 'id',
		'multilang' => false,
		'fields' => array(
			'num' =>			array('type' => self::TYPE_STRING),
		    'year' =>			array('type' => self::TYPE_INT),
		    'name' =>			array('type' => self::TYPE_STRING),
		    'idate' =>          array('type' => self::TYPE_DATE),
		)
	);
	
	public static function findByNum($num, $year, $id_order=null) {
	    if (empty($num) || empty($year)) return null;
	    $id = Fs2psTools::dbValue('
			select id from `@DB_fs2ps_invoice` i
            where `num`=\''.Fs2psTools::dbEscape($num).'\' and `year`='.(int)$year.' 
		');
	    if (empty($id)) {
	        // XXX: Compatibilidad hacia atrás
    	    $id = Fs2psTools::dbValue('
    			select id from `@DB_fs2ps_invoice` i
                left join `@DB_fs2ps_order_invoice` oi on oi.invoice=i.id
                where `num`=\''.Fs2psTools::dbEscape($num).'\' and (`year` is null or `year`=0)'.(empty($id_order)? '' : ' and oi.order='.(int)$id_order).'
    		');
	    }
	    if (empty($id)) return null;
	    return new Fs2psMyInvoice($id);
	}
	
	public static function orderHasInvoices($id_order) {
	    return Fs2psTools::dbValue('
			select count(1) from `@DB_fs2ps_order_invoice`
			where `order`='.$id_order.'
		') > 0;
	}
	
	public static function deleteOrderInvoices($id_order) {
	    // Delete files
	    $invoices = Fs2psTools::dbSelect('
			select oi.invoice as id
            from `@DB_fs2ps_order_invoice` oi
            where oi.`order`='.$id_order.'
		');
	    foreach ($invoices as $invoice) {
	        $invoice = new Fs2psMyInvoice($invoice['id']);
	        $invoice->deletePdf();
	    }
	    
	    // Delete database info
	    Fs2psTools::dbExec('
            delete i,oi
            from @DB_fs2ps_order_invoice oi
            left join @DB_fs2ps_invoice i on i.id=oi.invoice
            where oi.order='.$id_order.'
        ');
	}
	
	public static function customerCanViewInvoice($id_customer, $id_invoice) {
	    if (empty($id_customer)) return FALSE;
	    return Fs2psTools::dbValue('
			select count(1)
            from `@DB_fs2ps_order_invoice` oi
            inner join `@DB_orders` o on o.id_order=oi.order
            where oi.invoice='.$id_invoice.' and o.id_customer='.$id_customer.' 
		')? TRUE : FALSE;
	}
	
	protected static function getPdfUploadFolder($createFolders) {
	    $upload_folder = _PS_UPLOAD_DIR_.'fs2ps/invoices';
	    if ($createFolders && !file_exists($upload_folder)) {
	        if (!file_exists(_PS_UPLOAD_DIR_)) throw new Fs2psServerFatalException("No existe el directorio _PS_UPLOAD_DIR_");
	        Fs2psTools::mkdirs(_PS_UPLOAD_DIR_, 'fs2ps/invoices');
	    }
	    return $upload_folder;
	}
	
	protected function getPdfSubfolder() {
	    if (empty($this->year)) { // Old behaviour
    	    $hash = md5($this->num);
    	    return substr($hash, 0, 2).'/'.substr($hash, 2, 2);
	    } else { // New safer behaviour
	        $hash = md5(_COOKIE_KEY_.$this->num);
	        return  md5(_COOKIE_KEY_.'fs2psinvoices').'/'.$this->year.'/'.substr($hash, 0, 2).'/'.substr($hash, 2, 2);
	    }
	}
	
	protected function getPdfPath($createFolders) {
	    $upload_folder = $this->getPdfUploadFolder($createFolders);
	    $subfolder = $this->getPdfSubfolder();
	    $pdf_folder = $upload_folder.'/'.$subfolder;
	    if ($createFolders && !file_exists($pdf_folder)) {
	        Fs2psTools::mkdirs($upload_folder, $subfolder);
	    }
	    return $pdf_folder.'/'.$this->id.'.pdf';
	}
	
	public function deletePdf() {
	    $pdf_path = $this->getPdfPath(false);
	    if(file_exists($pdf_path)) unlink($pdf_path);
	}
	
	public function getPdf() {
	    return $this->getPdfPath(false);
	}
	
	public function saveDataAsPdf($data) {
	    $pdf_path = $this->getPdfPath(true);
	    $new_content = base64_decode($data);
	    if (file_exists($pdf_path)) {
	       $old_content_md5 = md5(file_get_contents($pdf_path));
	       $new_content_md5 = md5($new_content);
	       if ($old_content_md5 ==$new_content_md5) return false;
	    }
	    file_put_contents($pdf_path, $new_content);
	    return true;
	}
	
	protected static function getExtraEmails($order) {
	    $extra_emails = array();
	    $placeholders = array(
	        '${id_order}'=>(int)$order->id,
	        '${id_customer}'=>(int)$order->id_customer,
	        '${id_customer}'=>(int)$order->id_customer,
	        '${id_address_invoice}'=>(int)$order->id_address_invoice,
	        '${id_address_delivery}'=>(int)$order->id_address_delivery
	    );
	    
	    $strings = Fs2psTools::dbSelect(Fs2psTools::replaceTags('
            SELECT other as val
            FROM `@DB_address` a
            where a.`id_address`=${id_address_invoice}
		', $placeholders));
	    foreach ($strings as $string) {
	        $more_emails = Fs2psTools::extractEmails($string['val']);
	        if ($more_emails) $extra_emails = array_merge($extra_emails, $more_emails);
	    }
	    return $extra_emails;
	}
	
	public static function sendOrderInvoicesByEmail($id_order, $task=null) {
	    $id_order = intval($id_order);
	    
	    $order = new Order($id_order);
	    if (!Validate::isLoadedObject($order)) {
	        throw new Exception('No se pudieron enviar facturas del pedido '.$id_order.'. El pedido no existe.');
	    }
	    
	    $customer = new Customer((int)$order->id_customer);
	    if (!Validate::isLoadedObject($customer)) {
	        throw new Exception('No se pudieron enviar facturas del pedido '.$id_order.'. El cliente ya no existe.');
	    }
	    
	    $invoices = Fs2psTools::dbSelect('
			select oi.invoice as id
            from `@DB_fs2ps_order_invoice` oi
            where oi.`order`='.$id_order.'
		');
	    if ($invoices<=0) return;
	    
	    $file_attachment = array();
	    foreach ($invoices as $invoice) {
	        $invoice = new Fs2psMyInvoice($invoice['id']);
	        $file_attachment[] = array(
	            'content' => file_get_contents($invoice->getPdf()), 
	            'name' => $invoice->name, 
	            'mime' => 'application/pdf'
	        );
	    }
	    
        $mailVars = array(
            '{order_link}' => Context::getContext()->link->getPageLink('order', false, (int)$order->id_lang, 'step=3&recover_cart='.(int)$order->id.'&token_cart='.md5(_COOKIE_KEY_.'recover_cart_'.(int)$order->id)),
            '{firstname}' => $customer->firstname,
            '{lastname}' => $customer->lastname,
            '{order_name}' => $order->reference,
            '{order_id}' => $order->id,
        );
        
        $sended = 0;
        $emails = array($customer->email);
        $extra_emails = self::getExtraEmails($order);
        if ($extra_emails) {
            $emails = array_unique(array_merge($emails, $extra_emails));
        }
        foreach ($emails as $email) {
            if(Mail::Send(
                (int)$order->id_lang, 'invoice', 
                sprintf(Fs2psTools::l('Order %s invoice'), ($order->reference.' ('.$order->id.')')),
                $mailVars, $email, $customer->firstname.' '.$customer->lastname, 
                null, null, $file_attachment, 
                null, 
                _PS_MODULE_DIR_.'fs2psinvoices/mails/',
                true, $order->id_shop
            )) {
                $sended++;       
            } else if ($task) {
                $task->log('ERROR: No se pudieron enviar facturas a '.$email.' ¿Es correcto?');
            }
        }
        
        if ($sended) {
            Fs2psTools::dbExec('
    			update `@DB_fs2ps_order_invoice_summary` set `emailed`=\''.Fs2psTools::now().'\'
    			where `order`='.$id_order.'
    		');
        }
        
        return $sended>0;
	}
	
	public function returnPdfToBrowser() {
	    $content = file_get_contents($this->getPdf());
	    
	    header('Content-Type: application/pdf');
	    header('Cache-Control: no-cache ');
	    header('Pragma: public');
	    header('Expires: Sat, 26 Jul 1997 05:00:00 GMT'); // Date in the past
	    header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
	    header('Content-Disposition: inline; filename="'.$this->name.'"');
	    header('Content-Length: ' . strlen($content));
	    //ini_set('zlib.output_compression','0');
	    
	    die($content);
	}
	
	/**
	 * Guarda relación factura-pedido
	 * @param integer $id_order Id del pedido
	 * @param boolean $changed True si la factura cambió, para forzar almacenamiento de summario, false en caso contrario. 
	 * @return boolean
	 */
	public function addToOrder($id_order, $changed=true) {
	    $id_order = intval($id_order);
	    
	    Fs2psTools::dbExec('
			delete from `@DB_fs2ps_order_invoice`
            where `invoice`='.$this->id.' and `order`='.$id_order.'
		');
	    Fs2psTools::dbExec('
			insert into `@DB_fs2ps_order_invoice` (`order`, `invoice`)
			values ('.$id_order.', '.$this->id.')
		');
	    
	    $exists_summary = Fs2psTools::dbValue('
			select count(1) from `@DB_fs2ps_order_invoice_summary`
			where `order`='.$id_order.'
		');
	    if ($changed || !$exists_summary) {
    	    if ($exists_summary) {
    	        Fs2psTools::dbExec('
        			update `@DB_fs2ps_order_invoice_summary` set `updated`=\''.Fs2psTools::now().'\'
        			where `order`='.$id_order.'
        		');
    	    } else {
    	        Fs2psTools::dbExec('
        			insert into `@DB_fs2ps_order_invoice_summary` (`order`, `updated`)
        			values ('.$id_order.', \''.Fs2psTools::now().'\')
        		');
    	    }
    	    return true;
	    } else {
	        return false;
	    }
	    
	}

}
